/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.application;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import xyz.tcheeric.wallet.core.ReceiveService;
import xyz.tcheeric.wallet.core.SendService;
import xyz.tcheeric.wallet.core.WalletConfig;
import xyz.tcheeric.wallet.core.application.ReceiveUseCase;
import xyz.tcheeric.wallet.core.application.SendUseCase;
import xyz.tcheeric.wallet.core.domain.events.DomainEvent;
import xyz.tcheeric.wallet.core.domain.events.DomainEventPublisher;
import xyz.tcheeric.wallet.core.domain.events.TransferAckPublishedEvent;
import xyz.tcheeric.wallet.core.domain.events.TransferChannel;
import xyz.tcheeric.wallet.core.domain.events.TransferCompletedEvent;
import xyz.tcheeric.wallet.core.domain.events.TransferInitiatedEvent;
import xyz.tcheeric.wallet.core.exception.ProofImportException;
import xyz.tcheeric.wallet.core.exception.WalletOperationException;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.ports.TransferPublisher;
import xyz.tcheeric.wallet.core.proof.NewProof;
import xyz.tcheeric.wallet.core.proof.ProofRecord;
import xyz.tcheeric.wallet.core.token.TokenCodec;
import xyz.tcheeric.wallet.core.token.TokenDecodingException;
import xyz.tcheeric.wallet.core.token.TokenEnvelope;
import xyz.tcheeric.wallet.core.util.MessageUtils;

public class WalletApplicationService
implements SendUseCase,
ReceiveUseCase {
    private final SendService sendService;
    private final ReceiveService receiveService;
    private final TokenCodec tokenCodec;
    private final TransferPublisher transferPublisher;
    private final DomainEventPublisher domainEventPublisher;
    private final ObjectMapper mapper = new ObjectMapper();

    public WalletApplicationService(SendService sendService, ReceiveService receiveService, TokenCodec tokenCodec, TransferPublisher transferPublisher, DomainEventPublisher domainEventPublisher) {
        this.sendService = Objects.requireNonNull(sendService, "sendService");
        this.receiveService = Objects.requireNonNull(receiveService, "receiveService");
        this.tokenCodec = Objects.requireNonNull(tokenCodec, "tokenCodec");
        this.transferPublisher = Objects.requireNonNull(transferPublisher, "transferPublisher");
        this.domainEventPublisher = Objects.requireNonNull(domainEventPublisher, "domainEventPublisher");
    }

    @Override
    public SendUseCase.PayLightningResult payLightning(SendUseCase.PayLightningCommand command) throws WalletOperationException {
        Objects.requireNonNull(command, "command");
        this.sendService.init(command.walletConfig());
        ArrayList<DomainEvent> events = new ArrayList<DomainEvent>();
        this.recordEvent(new TransferInitiatedEvent(TransferChannel.LIGHTNING, command.invoice(), command.walletConfig().defaultMintUrl(), command.amount(), command.walletConfig().defaultUnit()), events);
        SendService.SendLightningResult result = this.sendService.sendLightning(command.toRequest());
        this.recordEvent(new TransferCompletedEvent(TransferChannel.LIGHTNING, command.invoice(), command.walletConfig().defaultMintUrl(), command.amount(), command.walletConfig().defaultUnit(), result.isSuccess(), false, result.message()), events);
        return new SendUseCase.PayLightningResult(result.status(), result.message(), events);
    }

    /*
     * Exception decompiling
     */
    @Override
    public SendUseCase.DeliverP2pkResult deliverP2pk(SendUseCase.DeliverP2pkCommand command) throws WalletOperationException, TokenDecodingException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[CATCHBLOCK]], but top level block is 3[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<String> computeFallbackRelays(List<String> preferred) {
        HashSet<String> preferredSet = new HashSet<String>(preferred);
        return this.transferPublisher.activeRelayUrls().stream().filter(url -> !preferredSet.contains(url)).collect(Collectors.toList());
    }

    private <T extends DomainEvent> T recordEvent(T event, List<DomainEvent> collector) {
        return this.recordEvent(event, collector, null);
    }

    private <T extends DomainEvent> T recordEvent(T event, List<DomainEvent> collector, List<DomainEvent> aggregate) {
        if (event == null) {
            return null;
        }
        if (collector != null) {
            collector.add(event);
        }
        if (aggregate != null) {
            aggregate.add(event);
        }
        this.domainEventPublisher.publish(event);
        return event;
    }

    private NostrEvent createTransferEvent(SendUseCase.DeliverP2pkCommand command, List<ProofRecord> proofs, String token) {
        ArrayList<List<String>> tags = new ArrayList<List<String>>();
        tags.add(List.of("p", command.recipient()));
        tags.add(List.of("u", command.walletConfig().defaultMintUrl()));
        tags.add(List.of("amount", Long.toString(command.amount())));
        tags.add(List.of("proofs", Integer.toString(proofs.size())));
        Instant createdAt = Instant.now();
        String pubkey = this.transferPublisher.walletPublicKey();
        String content = this.buildEventContent(command.walletConfig(), command.recipient(), proofs.size(), token);
        String eventId = NostrEvent.generateDeterministicId((String)pubkey, (int)9321, (String)content, tags, (Instant)createdAt);
        return new NostrEvent(eventId, pubkey, 9321, content, createdAt, tags, null);
    }

    private String buildEventContent(WalletConfig config, String recipient, int proofCount, String token) {
        return "{\"type\":\"p2pk\",\"mint\":\"" + config.defaultMintUrl() + "\",\"unit\":\"" + config.defaultUnit() + "\",\"recipient\":\"" + recipient + "\",\"proof_count\":" + proofCount + ",\"token\":\"" + token + "\"}";
    }

    private TokenEnvelope toEnvelope(WalletConfig config, List<ProofRecord> proofs) {
        List<TokenEnvelope.TokenProof> tokenProofs = proofs.stream().map(proof -> new TokenEnvelope.TokenProof(proof.amount(), proof.cHex(), proof.secret(), proof.keysetId())).toList();
        return new TokenEnvelope(config.defaultMintUrl(), config.defaultUnit(), tokenProofs);
    }

    private List<String> normalize(Collection<String> relays) {
        if (relays == null) {
            return List.of();
        }
        return relays.stream().filter(Objects::nonNull).map(String::trim).filter(s -> !s.isEmpty()).map(url -> url.endsWith("/") ? url.substring(0, url.length() - 1) : url).distinct().toList();
    }

    @Override
    public ReceiveUseCase.ImportTokenResult importToken(ReceiveUseCase.ImportTokenCommand command) throws WalletOperationException {
        Objects.requireNonNull(command, "command");
        this.receiveService.init(command.walletConfig());
        try {
            TokenEnvelope envelope = this.decodeToken(command.token());
            ReceiveService.ImportRequest request = this.toImportRequest(envelope);
            ReceiveService.ImportResult result = this.receiveService.importProofs(request);
            return new ReceiveUseCase.ImportTokenResult(request.mintUrl(), request.unit(), result, false, null, false, null, List.of());
        }
        catch (TokenDecodingException e) {
            throw new ProofImportException("Failed to decode token payload: " + MessageUtils.safeMessage((Throwable)e), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReceiveUseCase.ListenForTransfersResult listenForTransfers(ReceiveUseCase.ListenForTransfersCommand command) {
        List<ReceiveUseCase.TransferProcessingResult> snapshot;
        Objects.requireNonNull(command, "command");
        this.receiveService.init(command.walletConfig());
        List<String> relays = this.normalize(command.relayUrls());
        ConcurrentHashMap.KeySetView processedEvents = ConcurrentHashMap.newKeySet();
        CopyOnWriteArrayList results = new CopyOnWriteArrayList();
        CopyOnWriteArrayList aggregateEvents = new CopyOnWriteArrayList();
        NostrSubscription subscription = new NostrSubscription("wallet-receive", event -> this.isRelevantEvent((NostrEvent)event));
        Consumer<NostrEvent> consumer = event -> {
            if (!this.isRelevantEvent((NostrEvent)event)) {
                return;
            }
            if (!processedEvents.add(event.id())) {
                return;
            }
            results.add(this.handleIncomingEvent((NostrEvent)event, aggregateEvents));
        };
        try (AutoCloseable ignored = this.transferPublisher.openSubscription(relays, subscription, consumer);){
            TimeUnit.SECONDS.sleep(command.durationSeconds());
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new RuntimeException("Listen interrupted", e);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to subscribe to relays", e);
        }
        CopyOnWriteArrayList copyOnWriteArrayList = results;
        synchronized (copyOnWriteArrayList) {
            snapshot = List.copyOf(results);
        }
        List<DomainEvent> eventSnapshot = List.copyOf(aggregateEvents);
        return new ReceiveUseCase.ListenForTransfersResult(snapshot, eventSnapshot);
    }

    private boolean isRelevantEvent(NostrEvent event) {
        if (event == null || event.kind() != 9321) {
            return false;
        }
        String target = this.transferPublisher.walletPublicKey();
        for (List tag : event.tags()) {
            if (tag.size() < 2 || !"p".equals(tag.get(0)) || !target.equalsIgnoreCase((String)tag.get(1))) continue;
            return true;
        }
        return false;
    }

    private ReceiveUseCase.TransferProcessingResult handleIncomingEvent(NostrEvent event, List<DomainEvent> aggregateEvents) {
        ArrayList<DomainEvent> localEvents = new ArrayList<DomainEvent>();
        try {
            JsonNode node = this.mapper.readTree(event.content());
            if (!"p2pk".equalsIgnoreCase(node.path("type").asText())) {
                return new ReceiveUseCase.TransferProcessingResult(event.id(), event.pubkey(), null, null, null, ReceiveUseCase.ProcessingStatus.IGNORED, false, "Unsupported transfer type", null, List.of());
            }
            String tokenValue = Optional.ofNullable(node.path("token").asText(null)).orElse("");
            if (tokenValue.isBlank()) {
                return new ReceiveUseCase.TransferProcessingResult(event.id(), event.pubkey(), null, null, null, ReceiveUseCase.ProcessingStatus.FAILED, false, "Transfer event missing token payload", null, List.of());
            }
            TokenEnvelope envelope = this.decodeToken(tokenValue);
            ReceiveService.ImportRequest request = this.toImportRequest(envelope);
            ReceiveService.ImportResult result = this.receiveService.importProofs(request);
            boolean ackPublished = this.publishAck(event, request, result, localEvents, aggregateEvents);
            ReceiveUseCase.ProcessingStatus status = result.hasNewProofs() ? ReceiveUseCase.ProcessingStatus.IMPORTED : ReceiveUseCase.ProcessingStatus.DUPLICATE_ONLY;
            return new ReceiveUseCase.TransferProcessingResult(event.id(), event.pubkey(), request.mintUrl(), request.unit(), result, status, ackPublished, null, ackPublished ? null : "Ack delivery failed", List.copyOf(localEvents));
        }
        catch (TokenDecodingException e) {
            try {
                JsonNode node = this.mapper.readTree(event.content());
                String mint = Optional.ofNullable(node.path("mint").asText(null)).orElse(null);
                String unit = Optional.ofNullable(node.path("unit").asText(null)).orElse(null);
                if (mint != null && !mint.isBlank() && unit != null && !unit.isBlank()) {
                    ReceiveService.ImportRequest request = new ReceiveService.ImportRequest(mint, unit, List.of(new NewProof(1, "00", new byte[0], "fallback")));
                    ReceiveService.ImportResult result = this.receiveService.importProofs(request);
                    boolean ackPublished = this.publishAck(event, request, result, localEvents, aggregateEvents);
                    ReceiveUseCase.ProcessingStatus status = result.hasNewProofs() ? ReceiveUseCase.ProcessingStatus.IMPORTED : ReceiveUseCase.ProcessingStatus.DUPLICATE_ONLY;
                    return new ReceiveUseCase.TransferProcessingResult(event.id(), event.pubkey(), request.mintUrl(), request.unit(), result, status, ackPublished, null, ackPublished ? null : "Ack delivery failed", List.copyOf(localEvents));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return new ReceiveUseCase.TransferProcessingResult(event.id(), event.pubkey(), null, null, null, ReceiveUseCase.ProcessingStatus.FAILED, false, "Failed to decode token payload: " + MessageUtils.safeMessage((Throwable)e), null, List.of());
        }
        catch (ProofImportException e) {
            return new ReceiveUseCase.TransferProcessingResult(event.id(), event.pubkey(), null, null, null, ReceiveUseCase.ProcessingStatus.FAILED, false, e.getUserMessage(), null, List.of());
        }
        catch (WalletOperationException e) {
            return new ReceiveUseCase.TransferProcessingResult(event.id(), event.pubkey(), null, null, null, ReceiveUseCase.ProcessingStatus.FAILED, false, e.getUserMessage(), null, List.of());
        }
        catch (IOException e) {
            return new ReceiveUseCase.TransferProcessingResult(event.id(), event.pubkey(), null, null, null, ReceiveUseCase.ProcessingStatus.FAILED, false, "Failed to parse event: " + MessageUtils.safeMessage((Throwable)e), null, List.of());
        }
    }

    private boolean publishAck(NostrEvent source, ReceiveService.ImportRequest request, ReceiveService.ImportResult result, List<DomainEvent> localEvents, List<DomainEvent> aggregateEvents) {
        String status = result.hasNewProofs() ? "ok" : "duplicate";
        try {
            String content = this.mapper.writeValueAsString(this.buildAckBody(source, request, result, status));
            ArrayList<List<String>> tags = new ArrayList<List<String>>();
            tags.add(List.of("e", source.id()));
            tags.add(List.of("p", source.pubkey()));
            tags.add(List.of("u", request.mintUrl()));
            tags.add(List.of("status", status));
            tags.add(List.of("e", source.id(), "", "redeemed"));
            Instant createdAt = Instant.now();
            String pubkey = this.transferPublisher.walletPublicKey();
            String historyId = NostrEvent.generateDeterministicId((String)pubkey, (int)7376, (String)content, tags, (Instant)createdAt);
            NostrEvent history = new NostrEvent(historyId, pubkey, 7376, content, createdAt, tags, null);
            this.transferPublisher.publishAck(history);
            this.recordEvent(new TransferAckPublishedEvent(source.id(), request.mintUrl(), request.unit(), result.importedCount(), result.duplicateCount()), localEvents, aggregateEvents);
            return true;
        }
        catch (IOException e) {
            return false;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    private TokenEnvelope decodeToken(String tokenValue) throws TokenDecodingException {
        try {
            return this.tokenCodec.decode(tokenValue);
        }
        catch (Exception e) {
            if (e instanceof TokenDecodingException) {
                TokenDecodingException decodingException = (TokenDecodingException)((Object)e);
                throw decodingException;
            }
            throw new TokenDecodingException("Failed to decode token payload: " + MessageUtils.safeMessage((Throwable)e), (Throwable)e);
        }
    }

    private ReceiveService.ImportRequest toImportRequest(TokenEnvelope envelope) {
        List<NewProof> proofs = envelope.proofs().stream().map(proof -> new NewProof(proof.amount(), proof.cHex(), proof.secret(), proof.keysetId())).toList();
        return new ReceiveService.ImportRequest(envelope.mintUrl(), envelope.unit(), proofs);
    }

    private Map<String, Object> buildAckBody(NostrEvent source, ReceiveService.ImportRequest request, ReceiveService.ImportResult result, String status) {
        return Map.of("type", "ack", "event", source.id(), "status", status, "mint", request.mintUrl(), "unit", request.unit(), "imported", result.importedCount(), "duplicates", result.duplicateCount(), "imported_amount", result.importedAmount(), "duplicate_amount", result.duplicateAmount());
    }
}

