/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.backup;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.crypto.AesMnemonicEncryption;
import xyz.tcheeric.wallet.core.state.WalletState;
import xyz.tcheeric.wallet.core.state.WalletStateJsonCodec;

public class BackupService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(BackupService.class);
    private final ObjectMapper objectMapper;

    public BackupService() {
        this.objectMapper = WalletStateJsonCodec.newObjectMapper();
    }

    public BackupService(ObjectMapper objectMapper) {
        this.objectMapper = Objects.requireNonNull(objectMapper, "objectMapper");
    }

    public BackupResult createBackup(WalletState walletState, File outputFile, String passphrase, boolean json) throws BackupException {
        Objects.requireNonNull(walletState, "walletState");
        Objects.requireNonNull(outputFile, "outputFile");
        log.info("backup_creation_started output={} encrypted={}", (Object)outputFile.getAbsolutePath(), (Object)(!json ? 1 : 0));
        try {
            boolean encrypted;
            String backupContent;
            this.validateOutputFile(outputFile);
            String jsonBackup = this.serializeWalletState(walletState);
            if (json) {
                backupContent = jsonBackup;
                encrypted = false;
            } else {
                backupContent = this.encryptBackup(jsonBackup, passphrase);
                encrypted = true;
            }
            this.writeBackupToFile(backupContent, outputFile);
            BackupResult result = new BackupResult(outputFile, outputFile.length(), encrypted, walletState.isDeterministic(), walletState.tokens().size(), walletState.vouchers().size(), walletState.history().size());
            log.info("backup_creation_completed output={} size={} encrypted={}", new Object[]{outputFile.getAbsolutePath(), outputFile.length(), encrypted});
            return result;
        }
        catch (BackupException e) {
            log.error("backup_creation_failed error={}", (Object)e.getMessage(), (Object)e);
            throw e;
        }
        catch (Exception e) {
            log.error("backup_creation_failed error={}", (Object)e.getMessage(), (Object)e);
            throw new BackupException("Failed to create backup: " + e.getMessage(), e);
        }
    }

    private void validateOutputFile(File outputFile) throws BackupException {
        File parentDir = outputFile.getParentFile();
        if (parentDir != null && !parentDir.exists()) {
            throw new BackupException("Parent directory does not exist: " + parentDir.getAbsolutePath() + ". Suggestion: Create the directory first or use a different path");
        }
        if (outputFile.exists()) {
            log.warn("backup_file_exists_will_overwrite path={}", (Object)outputFile.getAbsolutePath());
        }
    }

    private String serializeWalletState(WalletState walletState) throws BackupException {
        try {
            String json = this.objectMapper.writerWithDefaultPrettyPrinter().writeValueAsString((Object)walletState);
            log.debug("wallet_state_serialized size_bytes={}", (Object)json.length());
            return json;
        }
        catch (IOException e) {
            throw new BackupException("Failed to serialize wallet state: " + e.getMessage(), e);
        }
    }

    private String encryptBackup(String jsonBackup, String passphrase) throws BackupException {
        if (passphrase == null || passphrase.isEmpty()) {
            throw new BackupException("Passphrase required for encrypted backup. Suggestion: Provide a strong passphrase using --passphrase");
        }
        try {
            String encryptedBackup = AesMnemonicEncryption.encrypt((String)jsonBackup, (String)passphrase);
            log.debug("backup_encrypted original_size={} encrypted_size={}", (Object)jsonBackup.length(), (Object)encryptedBackup.length());
            return encryptedBackup;
        }
        catch (Exception e) {
            throw new BackupException("Failed to encrypt backup: " + e.getMessage(), e);
        }
    }

    private void writeBackupToFile(String content, File outputFile) throws BackupException {
        try {
            Files.writeString(outputFile.toPath(), (CharSequence)content, StandardCharsets.UTF_8, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
            log.debug("backup_written_to_file path={} size={}", (Object)outputFile.getAbsolutePath(), (Object)outputFile.length());
        }
        catch (IOException e) {
            throw new BackupException("Failed to write backup file: " + e.getMessage(), e);
        }
    }

    public static class BackupResult {
        private final File outputFile;
        private final long fileSize;
        private final boolean encrypted;
        private final boolean deterministicWallet;
        private final int tokenCount;
        private final int voucherCount;
        private final int historyCount;

        public BackupResult(File outputFile, long fileSize, boolean encrypted, boolean deterministicWallet, int tokenCount, int voucherCount, int historyCount) {
            this.outputFile = outputFile;
            this.fileSize = fileSize;
            this.encrypted = encrypted;
            this.deterministicWallet = deterministicWallet;
            this.tokenCount = tokenCount;
            this.voucherCount = voucherCount;
            this.historyCount = historyCount;
        }

        public File getOutputFile() {
            return this.outputFile;
        }

        public long getFileSize() {
            return this.fileSize;
        }

        public boolean isEncrypted() {
            return this.encrypted;
        }

        public boolean isDeterministicWallet() {
            return this.deterministicWallet;
        }

        public int getTokenCount() {
            return this.tokenCount;
        }

        public int getVoucherCount() {
            return this.voucherCount;
        }

        public int getHistoryCount() {
            return this.historyCount;
        }
    }

    public static class BackupException
    extends Exception {
        public BackupException(String message) {
            super(message);
        }

        public BackupException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

