/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.exception;

import xyz.tcheeric.wallet.core.exception.WalletOperationException;

public final class RelayDeliveryException
extends WalletOperationException {
    private static final String RETRYABLE_SUGGESTION = "Retry the operation - relays may be temporarily unavailable. If retries fail, enable token fallback with the --fallback-to-token flag to ensure delivery.";
    private static final String NON_RETRYABLE_SUGGESTION = "Enable token fallback with the --fallback-to-token flag to generate a token for manual delivery. Alternatively, verify your relay configuration in ~/.cashu-client/config.json and ensure at least one relay is reachable.";

    public RelayDeliveryException(String userMessage, boolean retryable) {
        super("RELAY_DELIVERY_FAILED", retryable, userMessage, retryable ? RETRYABLE_SUGGESTION : NON_RETRYABLE_SUGGESTION);
    }

    public RelayDeliveryException(String userMessage, boolean retryable, Throwable cause) {
        super("RELAY_DELIVERY_FAILED", retryable, userMessage, retryable ? RETRYABLE_SUGGESTION : NON_RETRYABLE_SUGGESTION, cause);
    }

    public RelayDeliveryException(String userMessage, boolean retryable, String suggestion) {
        super("RELAY_DELIVERY_FAILED", retryable, userMessage, suggestion);
    }

    public RelayDeliveryException(String userMessage, boolean retryable, String suggestion, Throwable cause) {
        super("RELAY_DELIVERY_FAILED", retryable, userMessage, suggestion, cause);
    }
}

