/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.exception;

import xyz.tcheeric.wallet.core.exception.WalletOperationException;

public final class VoucherRedemptionException
extends WalletOperationException {
    private static final String DEFAULT_SUGGESTION = "Verify the voucher ID, ensure it has not expired or been revoked, and try again.";

    private VoucherRedemptionException(String userMessage, boolean retryable, String suggestion) {
        super("VOUCHER_REDEMPTION_FAILED", retryable, userMessage, suggestion);
    }

    private VoucherRedemptionException(String userMessage, boolean retryable, String suggestion, Throwable cause) {
        super("VOUCHER_REDEMPTION_FAILED", retryable, userMessage, suggestion, cause);
    }

    public static VoucherRedemptionException notFound(String voucherId) {
        return new VoucherRedemptionException("Voucher " + voucherId + " was not found in this wallet.", false, "List vouchers with `wallet voucher list` to verify the ID, then retry with a valid voucher.");
    }

    public static VoucherRedemptionException alreadyRedeemed(String voucherId) {
        return new VoucherRedemptionException("Voucher " + voucherId + " was already redeemed.", false, "Use the voucher history to confirm the previous redemption. If this is unexpected, contact the issuer.");
    }

    public static VoucherRedemptionException expired(String voucherId) {
        return new VoucherRedemptionException("Voucher " + voucherId + " has expired.", false, "Inform the customer that the voucher expired. Coordinate with the issuer if an extension is needed.");
    }

    public static VoucherRedemptionException revoked(String voucherId) {
        return new VoucherRedemptionException("Voucher " + voucherId + " has been revoked by the issuer.", false, "Decline the voucher and ask the customer to contact the issuer for clarification.");
    }

    public static VoucherRedemptionException ledgerConflict(String voucherId, String reason) {
        return new VoucherRedemptionException("Voucher " + voucherId + " cannot be redeemed because the ledger reports: " + reason, false, "Review the voucher status on the ledger and coordinate with the issuer before retrying.");
    }

    public static VoucherRedemptionException unexpected(String voucherId, Throwable cause) {
        return new VoucherRedemptionException("Unexpected error while redeeming voucher " + voucherId + ": " + cause.getMessage(), true, DEFAULT_SUGGESTION, cause);
    }
}

