/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.validation;

import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.Locale;
import java.util.Set;
import xyz.tcheeric.wallet.core.validation.Bech32;
import xyz.tcheeric.wallet.core.validation.Bolt11;

public final class Bolt11Validator
implements ConstraintValidator<Bolt11, String> {
    private static final Set<String> SUPPORTED_PREFIXES = Set.of("bc", "tb", "sb", "bcrt");

    public boolean isValid(String value, ConstraintValidatorContext context) {
        int index;
        String normalized;
        if (value == null) {
            return true;
        }
        String trimmed = value.trim();
        if (trimmed.isEmpty() || !trimmed.equals(value)) {
            return false;
        }
        boolean lower = trimmed.equals(trimmed.toLowerCase(Locale.ROOT));
        boolean upper = trimmed.equals(trimmed.toUpperCase(Locale.ROOT));
        if (!lower && !upper) {
            return false;
        }
        String string = normalized = lower ? trimmed : trimmed.toLowerCase(Locale.ROOT);
        if (!normalized.startsWith("ln")) {
            return false;
        }
        int separator = normalized.lastIndexOf(49);
        if (separator < 3 || separator == normalized.length() - 1) {
            return false;
        }
        String hrp = normalized.substring(0, separator);
        String data = normalized.substring(separator + 1);
        if (data.length() < 6 || !Bech32.containsOnlyCharset((String)data)) {
            return false;
        }
        if (!Bech32.hasValidChecksum((String)hrp, (String)data)) {
            return false;
        }
        String currencyAndAmount = hrp.substring(2);
        if (currencyAndAmount.isEmpty()) {
            return false;
        }
        for (index = 0; index < currencyAndAmount.length() && Character.isLetter(currencyAndAmount.charAt(index)); ++index) {
        }
        String prefix = currencyAndAmount.substring(0, index);
        if (!SUPPORTED_PREFIXES.contains(prefix)) {
            return false;
        }
        String amountPart = currencyAndAmount.substring(index);
        return amountPart.isEmpty() || this.isValidAmount(amountPart);
    }

    private boolean isValidAmount(String amountPart) {
        int letterPosition = -1;
        for (int i = 0; i < amountPart.length(); ++i) {
            char ch = amountPart.charAt(i);
            if (Character.isDigit(ch)) {
                if (letterPosition < 0) continue;
                return false;
            }
            if (letterPosition >= 0) {
                return false;
            }
            if (i == 0) {
                return false;
            }
            if ("munp".indexOf(ch) < 0) {
                return false;
            }
            letterPosition = i;
        }
        return true;
    }
}

