/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import java.io.File;
import java.nio.file.Path;

public final class StoragePaths {
    private StoragePaths() {
    }

    public static Path walletHome() {
        String[] candidates;
        for (String c : candidates = new String[]{System.getProperty("WALLET_HOME"), System.getProperty("CASHU_HOME"), System.getenv("WALLET_HOME"), System.getenv("CASHU_HOME")}) {
            if (c == null || c.isBlank()) continue;
            return Path.of(c, new String[0]);
        }
        String userHome = System.getProperty("user.home", ".");
        return Path.of(userHome, ".cashu-client");
    }

    public static Path configFile() {
        return StoragePaths.walletHome().resolve("config.properties");
    }

    public static Path balanceFile() {
        return StoragePaths.walletHome().resolve("balance.properties");
    }

    public static Path encMetaFile() {
        return StoragePaths.walletHome().resolve("enc.properties");
    }

    public static Path relayHealthFile() {
        return StoragePaths.walletHome().resolve("relay-health.properties");
    }

    public static void ensureDirs() {
        File dir = StoragePaths.walletHome().toFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }
}

