/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.crypto;

import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.security.SecureRandom;
import java.util.Base64;
import javax.crypto.AEADBadTagException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.GCMParameterSpec;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AesMnemonicEncryption {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AesMnemonicEncryption.class);
    private static final String ALGORITHM = "AES/GCM/NoPadding";
    private static final String KEY_DERIVATION_ALGORITHM = "PBKDF2WithHmacSHA256";
    private static final int KEY_LENGTH = 256;
    private static final int GCM_TAG_LENGTH = 128;
    private static final int GCM_IV_LENGTH = 96;
    private static final int SALT_LENGTH = 128;
    private static final int PBKDF2_ITERATIONS = 100000;
    private static final SecureRandom SECURE_RANDOM = new SecureRandom();

    private AesMnemonicEncryption() {
    }

    public static String encrypt(String mnemonic, String passphrase) {
        if (mnemonic == null || mnemonic.trim().isEmpty()) {
            throw new IllegalArgumentException("Mnemonic cannot be null or empty. Suggestion: Provide a valid BIP39 mnemonic phrase.");
        }
        if (passphrase == null) {
            throw new IllegalArgumentException("Passphrase cannot be null. Suggestion: Provide a passphrase (use empty string if none).");
        }
        try {
            byte[] salt = AesMnemonicEncryption.generateSalt();
            byte[] iv = AesMnemonicEncryption.generateIv();
            SecretKey key = AesMnemonicEncryption.deriveKey(passphrase, salt);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(1, (Key)key, gcmSpec);
            byte[] plaintextBytes = mnemonic.getBytes(StandardCharsets.UTF_8);
            byte[] ciphertext = cipher.doFinal(plaintextBytes);
            String saltBase64 = Base64.getEncoder().encodeToString(salt);
            String ivBase64 = Base64.getEncoder().encodeToString(iv);
            String ciphertextBase64 = Base64.getEncoder().encodeToString(ciphertext);
            log.debug("mnemonic_encrypted salt_length={} iv_length={} ciphertext_length={}", new Object[]{salt.length, iv.length, ciphertext.length});
            return saltBase64 + ":" + ivBase64 + ":" + ciphertextBase64;
        }
        catch (Exception e) {
            log.error("mnemonic_encryption_failed error={}", (Object)e.getMessage(), (Object)e);
            throw new MnemonicEncryptionException("Failed to encrypt mnemonic. " + e.getMessage() + ". Suggestion: Verify the passphrase and try again.", e);
        }
    }

    public static String decrypt(String encryptedData, String passphrase) {
        if (encryptedData == null || encryptedData.trim().isEmpty()) {
            throw new IllegalArgumentException("Encrypted data cannot be null or empty. Suggestion: Provide valid encrypted mnemonic data.");
        }
        if (passphrase == null) {
            throw new IllegalArgumentException("Passphrase cannot be null. Suggestion: Provide the passphrase used during encryption.");
        }
        try {
            String[] parts = encryptedData.split(":", 3);
            if (parts.length != 3) {
                throw new IllegalArgumentException("Invalid encrypted data format. Expected format: salt:iv:ciphertext. Suggestion: Verify the encrypted data was not corrupted.");
            }
            byte[] salt = Base64.getDecoder().decode(parts[0]);
            byte[] iv = Base64.getDecoder().decode(parts[1]);
            byte[] ciphertext = Base64.getDecoder().decode(parts[2]);
            SecretKey key = AesMnemonicEncryption.deriveKey(passphrase, salt);
            Cipher cipher = Cipher.getInstance(ALGORITHM);
            GCMParameterSpec gcmSpec = new GCMParameterSpec(128, iv);
            cipher.init(2, (Key)key, gcmSpec);
            byte[] plaintextBytes = cipher.doFinal(ciphertext);
            String mnemonic = new String(plaintextBytes, StandardCharsets.UTF_8);
            log.debug("mnemonic_decrypted mnemonic_length={}", (Object)mnemonic.length());
            return mnemonic;
        }
        catch (AEADBadTagException e) {
            log.warn("mnemonic_decryption_failed_bad_tag reason=incorrect_passphrase_or_corrupted_data");
            throw new MnemonicDecryptionException("Failed to decrypt mnemonic: incorrect passphrase or data corruption. Suggestion: Verify the passphrase is correct.", e);
        }
        catch (Exception e) {
            log.error("mnemonic_decryption_failed error={}", (Object)e.getMessage(), (Object)e);
            throw new MnemonicDecryptionException("Failed to decrypt mnemonic. " + e.getMessage() + ". Suggestion: Verify the encrypted data and passphrase are correct.", e);
        }
    }

    private static SecretKey deriveKey(String passphrase, byte[] salt) throws Exception {
        SecretKeyFactory factory = SecretKeyFactory.getInstance(KEY_DERIVATION_ALGORITHM);
        PBEKeySpec spec = new PBEKeySpec(passphrase.toCharArray(), salt, 100000, 256);
        SecretKey tmp = factory.generateSecret(spec);
        return new SecretKeySpec(tmp.getEncoded(), "AES");
    }

    private static byte[] generateSalt() {
        byte[] salt = new byte[16];
        SECURE_RANDOM.nextBytes(salt);
        return salt;
    }

    private static byte[] generateIv() {
        byte[] iv = new byte[12];
        SECURE_RANDOM.nextBytes(iv);
        return iv;
    }

    public static class MnemonicEncryptionException
    extends RuntimeException {
        public MnemonicEncryptionException(String message, Throwable cause) {
            super(message, cause);
        }
    }

    public static class MnemonicDecryptionException
    extends RuntimeException {
        public MnemonicDecryptionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

