/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.ports;

import java.util.List;
import java.util.concurrent.CompletableFuture;
import xyz.tcheeric.wallet.core.ports.TransferMessage;

public interface TransferPublisher {
    public CompletableFuture<PublishResult> publish(TransferMessage var1);

    public CompletableFuture<PublishResult> publishWithAck(TransferMessage var1, boolean var2);

    public boolean isHealthy();

    public List<String> getActiveEndpoints();

    public record PublishResult(String transferId, boolean delivered, List<String> endpoints, boolean acknowledged, String error) {
        public PublishResult {
            endpoints = endpoints == null ? List.of() : List.copyOf(endpoints);
        }

        public static PublishResult success(String transferId, List<String> endpoints) {
            return new PublishResult(transferId, true, endpoints, false, null);
        }

        public static PublishResult successWithAck(String transferId, List<String> endpoints) {
            return new PublishResult(transferId, true, endpoints, true, null);
        }

        public static PublishResult failure(String transferId, String error) {
            return new PublishResult(transferId, false, List.of(), false, error);
        }
    }
}

