/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.security;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.Base64;
import java.util.Properties;
import xyz.tcheeric.wallet.core.StoragePaths;

public class EncryptionMetadataRepository {
    public EncryptionMetadata load() {
        try {
            if (!Files.exists(StoragePaths.encMetaFile(), new LinkOption[0])) {
                return new EncryptionMetadata(false, null, null, 0, null, null, null);
            }
            Properties properties = new Properties();
            try (FileInputStream is = new FileInputStream(StoragePaths.encMetaFile().toFile());){
                properties.load(is);
            }
            boolean enabled = Boolean.parseBoolean(properties.getProperty("enc.enabled", "false"));
            String version = properties.getProperty("enc.version");
            String kdf = properties.getProperty("kdf");
            int iter = Integer.parseInt(properties.getProperty("kdf.iter", "0"));
            byte[] salt = EncryptionMetadataRepository.b64d(properties.getProperty("kdf.salt"));
            byte[] dekIv = EncryptionMetadataRepository.b64d(properties.getProperty("dek.iv"));
            byte[] dekCt = EncryptionMetadataRepository.b64d(properties.getProperty("dek.ct"));
            return new EncryptionMetadata(enabled, version, kdf, iter, salt, dekIv, dekCt);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to load encryption metadata", e);
        }
    }

    public void save(EncryptionMetadata metadata) {
        try {
            Properties properties = new Properties();
            properties.setProperty("enc.enabled", Boolean.toString(metadata.enabled()));
            if (metadata.version() != null) {
                properties.setProperty("enc.version", metadata.version());
            }
            if (metadata.kdf() != null) {
                properties.setProperty("kdf", metadata.kdf());
            }
            properties.setProperty("kdf.iter", Integer.toString(metadata.kdfIter()));
            if (metadata.salt() != null) {
                properties.setProperty("kdf.salt", EncryptionMetadataRepository.b64(metadata.salt()));
            }
            if (metadata.dekIv() != null) {
                properties.setProperty("dek.iv", EncryptionMetadataRepository.b64(metadata.dekIv()));
            }
            if (metadata.dekCt() != null) {
                properties.setProperty("dek.ct", EncryptionMetadataRepository.b64(metadata.dekCt()));
            }
            StoragePaths.ensureDirs();
            try (FileOutputStream os = new FileOutputStream(StoragePaths.encMetaFile().toFile());){
                properties.store(os, "encryption metadata");
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to store encryption metadata", e);
        }
    }

    private static String b64(byte[] b) {
        return Base64.getEncoder().encodeToString(b);
    }

    private static byte[] b64d(String s) {
        return s == null ? null : Base64.getDecoder().decode(s);
    }

    public record EncryptionMetadata(boolean enabled, String version, String kdf, int kdfIter, byte[] salt, byte[] dekIv, byte[] dekCt) {
    }
}

