/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.HexFormat;
import java.util.Objects;
import java.util.Properties;
import nostr.base.PrivateKey;
import nostr.base.PublicKey;
import nostr.crypto.schnorr.Schnorr;
import xyz.tcheeric.wallet.core.StoragePaths;
import xyz.tcheeric.wallet.core.security.IdentityKey;

public class IdentityKeyService {
    private final Path walletHome;
    private final Path identityFile;

    public IdentityKeyService() {
        this(StoragePaths.walletHome());
    }

    public IdentityKeyService(Path walletHome) {
        this.walletHome = Objects.requireNonNull(walletHome, "walletHome");
        this.identityFile = walletHome.resolve("identity.keys");
    }

    public synchronized IdentityKey loadOrCreate() {
        try {
            if (Files.exists(this.identityFile, new LinkOption[0])) {
                return this.load();
            }
            return this.createAndStore();
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to load identity key", e);
        }
    }

    private IdentityKey load() throws IOException {
        Properties props = new Properties();
        try (InputStream in = Files.newInputStream(this.identityFile, new OpenOption[0]);){
            props.load(in);
        }
        String privHex = props.getProperty("private");
        String pubHex = props.getProperty("public");
        if (privHex == null || pubHex == null) {
            throw new IllegalStateException("Identity key file is missing required fields");
        }
        if (privHex.length() != 64 || pubHex.length() != 64) {
            return this.migrateLegacyKey(privHex, pubHex);
        }
        byte[] privBytes = HexFormat.of().parseHex(privHex);
        byte[] pubBytes = HexFormat.of().parseHex(pubHex);
        PrivateKey privateKey = new PrivateKey(privBytes);
        PublicKey publicKey = new PublicKey(pubBytes);
        return IdentityKey.fromNostrJava(privateKey, publicKey);
    }

    private IdentityKey migrateLegacyKey(String legacyPrivBase64, String legacyPubBase64) throws IOException {
        byte[] privDER = Base64.getDecoder().decode(legacyPrivBase64);
        byte[] pubDER = Base64.getDecoder().decode(legacyPubBase64);
        byte[] rawPrivKey = new byte[32];
        byte[] rawPubKey = new byte[32];
        System.arraycopy(privDER, privDER.length - 32, rawPrivKey, 0, 32);
        System.arraycopy(pubDER, pubDER.length - 32, rawPubKey, 0, 32);
        PrivateKey privateKey = new PrivateKey(rawPrivKey);
        PublicKey publicKey = new PublicKey(rawPubKey);
        this.storeKeys(privateKey, publicKey);
        return IdentityKey.fromNostrJava(privateKey, publicKey);
    }

    private IdentityKey createAndStore() throws IOException {
        Files.createDirectories(this.walletHome, new FileAttribute[0]);
        PrivateKey privateKey = PrivateKey.generateRandomPrivKey();
        byte[] pubKeyBytes = Schnorr.genPubKey((byte[])privateKey.getRawData());
        PublicKey publicKey = new PublicKey(pubKeyBytes);
        this.storeKeys(privateKey, publicKey);
        return IdentityKey.fromNostrJava(privateKey, publicKey);
    }

    private void storeKeys(PrivateKey privateKey, PublicKey publicKey) throws IOException {
        Properties props = new Properties();
        String privHex = HexFormat.of().formatHex(privateKey.getRawData());
        String pubHex = HexFormat.of().formatHex(publicKey.getRawData());
        props.setProperty("private", privHex);
        props.setProperty("public", pubHex);
        try (OutputStream out = Files.newOutputStream(this.identityFile, new OpenOption[0]);){
            props.store(out, "wallet identity key (nostr-java format)");
        }
    }
}

