/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.security;

import de.mkammerer.argon2.Argon2Advanced;
import de.mkammerer.argon2.Argon2Factory;
import java.security.GeneralSecurityException;
import java.util.Arrays;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import xyz.tcheeric.wallet.core.security.KeyDerivationException;

public class KeyDerivationService {
    private static final String PBKDF2_JAVA = "PBKDF2WithHmacSHA256";

    public byte[] derive(String kdfName, char[] pass, byte[] salt, int iter) throws KeyDerivationException {
        if ("argon2id".equalsIgnoreCase(kdfName)) {
            int iterations = Math.max(2, iter / 100000);
            int memory = 65536;
            int parallelism = Math.min(2, Runtime.getRuntime().availableProcessors());
            char[] copy = Arrays.copyOf(pass, pass.length);
            Argon2Advanced argon2 = null;
            try {
                argon2 = Argon2Factory.createAdvanced((Argon2Factory.Argon2Types)Argon2Factory.Argon2Types.ARGON2id);
                byte[] hash = argon2.rawHash(iterations, memory, parallelism, copy, salt);
                byte[] byArray = Arrays.copyOf(hash, 32);
                return byArray;
            }
            catch (Throwable e) {
                throw new KeyDerivationException("Argon2id key derivation failed", e);
            }
            finally {
                if (argon2 != null) {
                    argon2.wipeArray(copy);
                }
                Arrays.fill(copy, '\u0000');
            }
        }
        try {
            PBEKeySpec spec = new PBEKeySpec(pass, salt, iter, 256);
            return SecretKeyFactory.getInstance(PBKDF2_JAVA).generateSecret(spec).getEncoded();
        }
        catch (GeneralSecurityException e) {
            throw new KeyDerivationException("PBKDF2 key derivation failed", e);
        }
    }
}

