/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.security;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.util.Optional;
import javax.crypto.spec.SecretKeySpec;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;

class PlatformSecureKeyStore
implements SecureKeyStore {
    private final Path walletHome;
    private final Path storePath;
    private final char[] password;
    private KeyStore keyStore;

    PlatformSecureKeyStore(Path walletHome, char[] password) {
        if (password == null || password.length == 0) {
            throw new IllegalArgumentException("Password is required for platform key store");
        }
        this.walletHome = walletHome;
        this.storePath = walletHome.resolve("wallet-secrets.p12");
        this.password = (char[])password.clone();
    }

    @Override
    public synchronized Optional<byte[]> load(String alias) {
        try {
            KeyStore ks = this.ensureLoaded();
            if (!ks.containsAlias(alias)) {
                return Optional.empty();
            }
            KeyStore.Entry entry = ks.getEntry(alias, new KeyStore.PasswordProtection(this.password));
            if (entry instanceof KeyStore.SecretKeyEntry) {
                KeyStore.SecretKeyEntry secretKeyEntry = (KeyStore.SecretKeyEntry)entry;
                return Optional.of(secretKeyEntry.getSecretKey().getEncoded());
            }
            return Optional.empty();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Failed to load secret from keystore", e);
        }
    }

    @Override
    public synchronized void store(String alias, byte[] value) {
        try {
            KeyStore ks = this.ensureLoaded();
            SecretKeySpec secretKey = new SecretKeySpec(value, "RAW");
            ks.setEntry(alias, new KeyStore.SecretKeyEntry(secretKey), new KeyStore.PasswordProtection(this.password));
            try (OutputStream out = Files.newOutputStream(this.storePath, new OpenOption[0]);){
                ks.store(out, this.password);
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalStateException("Failed to store secret in keystore", e);
        }
    }

    private KeyStore ensureLoaded() throws IOException, GeneralSecurityException {
        if (this.keyStore != null) {
            return this.keyStore;
        }
        Files.createDirectories(this.walletHome, new FileAttribute[0]);
        this.keyStore = KeyStore.getInstance("PKCS12");
        if (Files.exists(this.storePath, new LinkOption[0])) {
            try (InputStream in = Files.newInputStream(this.storePath, new OpenOption[0]);){
                this.keyStore.load(in, this.password);
            }
        }
        this.keyStore.load(null, this.password);
        try (OutputStream out = Files.newOutputStream(this.storePath, new OpenOption[0]);){
            this.keyStore.store(out, this.password);
        }
        return this.keyStore;
    }
}

