/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.KeyDerivationException;
import xyz.tcheeric.wallet.core.security.KeyDerivationService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

public class WalletKeyManager {
    private static final String KEY_ALIAS = "wallet-device-key";
    private static final int DEFAULT_ITERATIONS = 600000;
    private final SecureKeyStore secureKeyStore;
    private final KeyDerivationService keyDerivationService = new KeyDerivationService();
    private final SecureRandom secureRandom = new SecureRandom();

    public WalletKeyManager(SecureKeyStore secureKeyStore) {
        this.secureKeyStore = Objects.requireNonNull(secureKeyStore, "secureKeyStore");
    }

    public synchronized WalletSigningKey loadOrCreate(IdentityKey identityKey) {
        Objects.requireNonNull(identityKey, "identityKey");
        Optional<byte[]> existing = this.secureKeyStore.load(KEY_ALIAS);
        if (existing.isPresent()) {
            return this.deserialize(existing.get());
        }
        WalletSigningKey key = this.derive(identityKey);
        this.secureKeyStore.store(KEY_ALIAS, this.serialize(key));
        return key;
    }

    private WalletSigningKey derive(IdentityKey identityKey) {
        byte[] salt = new byte[16];
        this.secureRandom.nextBytes(salt);
        try {
            String passphrase = Base64.getEncoder().encodeToString(identityKey.privateKeyEncoded());
            byte[] seed = this.keyDerivationService.derive("argon2id", passphrase.toCharArray(), salt, 600000);
            Ed25519PrivateKeyParameters privParams = new Ed25519PrivateKeyParameters(seed, 0);
            Ed25519PublicKeyParameters pubParams = privParams.generatePublicKey();
            return new WalletSigningKey(privParams.getEncoded(), pubParams.getEncoded(), salt, 600000);
        }
        catch (KeyDerivationException e) {
            throw new IllegalStateException("Failed to derive wallet signing key", e);
        }
    }

    private byte[] serialize(WalletSigningKey key) {
        byte[] byArray;
        Properties props = new Properties();
        props.setProperty("v", "1");
        props.setProperty("iter", Integer.toString(key.iterations()));
        props.setProperty("salt", Base64.getEncoder().encodeToString(key.salt()));
        props.setProperty("priv", Base64.getEncoder().encodeToString(key.privateKey()));
        props.setProperty("pub", Base64.getEncoder().encodeToString(key.publicKey()));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            props.store(out, "wallet signing key");
            byArray = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to serialize wallet signing key", e);
            }
        }
        out.close();
        return byArray;
    }

    private WalletSigningKey deserialize(byte[] data) {
        Properties props = new Properties();
        try (ByteArrayInputStream in = new ByteArrayInputStream(data);){
            props.load(in);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to deserialize wallet signing key", e);
        }
        int iterations = Integer.parseInt(props.getProperty("iter", String.valueOf(600000)));
        byte[] salt = Base64.getDecoder().decode(props.getProperty("salt"));
        byte[] priv = Base64.getDecoder().decode(props.getProperty("priv"));
        byte[] pub = Base64.getDecoder().decode(props.getProperty("pub"));
        return new WalletSigningKey(priv, pub, salt, iterations);
    }
}

