/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.security;

import java.util.Arrays;
import java.util.HexFormat;

public record WalletSigningKey(byte[] privateKey, byte[] publicKey, byte[] salt, int iterations) {
    private final byte[] privateKey;
    private final byte[] publicKey;
    private final byte[] salt;

    public WalletSigningKey {
        privateKey = privateKey != null ? Arrays.copyOf(privateKey, privateKey.length) : new byte[]{};
        publicKey = publicKey != null ? Arrays.copyOf(publicKey, publicKey.length) : new byte[]{};
        salt = salt != null ? Arrays.copyOf(salt, salt.length) : new byte[]{};
    }

    public byte[] privateKey() {
        return Arrays.copyOf(this.privateKey, this.privateKey.length);
    }

    public byte[] publicKey() {
        return Arrays.copyOf(this.publicKey, this.publicKey.length);
    }

    public byte[] salt() {
        return Arrays.copyOf(this.salt, this.salt.length);
    }

    public String publicKeyHex() {
        return HexFormat.of().formatHex(this.publicKey);
    }
}

