/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.state;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Positive;
import java.time.Instant;
import java.util.Objects;

public record StoredVoucher(@NotBlank @JsonProperty(value="voucher_id") String voucherId, @NotBlank @JsonProperty(value="issuer_id") String issuerId, @NotBlank String unit, @Positive @JsonProperty(value="face_value") long faceValue, @JsonProperty(value="expires_at") Long expiresAt, String memo, @NotBlank @JsonProperty(value="issuer_signature") String issuerSignature, @NotBlank @JsonProperty(value="issuer_public_key") String issuerPublicKey, @NotNull @JsonProperty(value="issued_at") Instant issuedAt, @NotBlank String status) {
    public StoredVoucher(@NotBlank @JsonProperty(value="voucher_id") String voucherId, @NotBlank @JsonProperty(value="issuer_id") String issuerId, @NotBlank String unit, @Positive @JsonProperty(value="face_value") long faceValue, @JsonProperty(value="expires_at") Long expiresAt, String memo, @NotBlank @JsonProperty(value="issuer_signature") String issuerSignature, @NotBlank @JsonProperty(value="issuer_public_key") String issuerPublicKey, @NotNull @JsonProperty(value="issued_at") Instant issuedAt, @NotBlank String status) {
        Objects.requireNonNull(voucherId, "voucherId");
        Objects.requireNonNull(issuerId, "issuerId");
        Objects.requireNonNull(unit, "unit");
        Objects.requireNonNull(issuerSignature, "issuerSignature");
        Objects.requireNonNull(issuerPublicKey, "issuerPublicKey");
        issuedAt = issuedAt == null ? Instant.now() : issuedAt;
        status = status == null ? "issued" : status;
    }

    public boolean isExpired() {
        return this.expiresAt != null && Instant.now().getEpochSecond() > this.expiresAt;
    }

    public boolean isActive() {
        return "issued".equals(this.status) && !this.isExpired();
    }
}

