/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.state;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;

public record VoucherBackupState(@JsonProperty(value="last_backup_at") Instant lastBackupAt, @JsonProperty(value="last_restore_at") Instant lastRestoreAt, @JsonProperty(value="backup_count") Integer backupCount, @JsonProperty(value="voucher_count") Integer voucherCount) {
    public VoucherBackupState {
        backupCount = backupCount == null ? 0 : backupCount;
        voucherCount = voucherCount == null ? 0 : voucherCount;
    }

    public VoucherBackupState() {
        this(null, null, 0, 0);
    }

    public VoucherBackupState withBackup(int voucherCount) {
        return new VoucherBackupState(Instant.now(), this.lastRestoreAt, this.backupCount + 1, voucherCount);
    }

    public VoucherBackupState withRestore() {
        return new VoucherBackupState(this.lastBackupAt, Instant.now(), this.backupCount, this.voucherCount);
    }

    public boolean hasBackup() {
        return this.lastBackupAt != null;
    }

    public boolean hasRestore() {
        return this.lastRestoreAt != null;
    }
}

