/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.state;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.state.SchemaVersion;
import xyz.tcheeric.wallet.core.state.WalletSchemaMetadata;

public final class WalletSchemaNegotiator {
    private static final Logger LOGGER = LoggerFactory.getLogger(WalletSchemaNegotiator.class);
    public static final List<SchemaVersion> LOCAL_PREFERENCE = List.of(SchemaVersion.V1_1, SchemaVersion.V1_0);

    public WalletSchemaMetadata negotiate(WalletSchemaMetadata advertised) {
        Objects.requireNonNull(advertised, "advertised");
        SchemaVersion negotiated = this.resolveNegotiatedVersion(advertised.remoteSupported(), advertised.remoteMinimum());
        return new WalletSchemaMetadata(negotiated, advertised.remoteAdvertised(), advertised.remoteMinimum(), advertised.remoteSupported(), LOCAL_PREFERENCE);
    }

    public SchemaVersion resolveNegotiatedVersion(List<SchemaVersion> remoteSupported, SchemaVersion remoteMinimum) {
        Objects.requireNonNull(remoteSupported, "remoteSupported");
        Objects.requireNonNull(remoteMinimum, "remoteMinimum");
        if (!remoteSupported.isEmpty()) {
            for (SchemaVersion candidate : LOCAL_PREFERENCE) {
                if (!remoteSupported.contains(candidate) || candidate.compareTo(remoteMinimum) < 0) continue;
                return candidate;
            }
            throw new IllegalStateException("No compatible wallet schema version available");
        }
        SchemaVersion earliest = SchemaVersion.earliest();
        if (earliest.compareTo(remoteMinimum) >= 0) {
            LOGGER.warn("wallet_state schema_negotiation_fallback reason=remote_omits_supported minimum={} chosen={}", (Object)remoteMinimum, (Object)earliest);
            return earliest;
        }
        throw new IllegalStateException("No compatible wallet schema version available");
    }

    public WalletSchemaMetadata advertisedMetadata(SchemaVersion remoteAdvertised, SchemaVersion remoteMinimum, List<SchemaVersion> remoteSupported) {
        Objects.requireNonNull(remoteAdvertised, "remoteAdvertised");
        Objects.requireNonNull(remoteMinimum, "remoteMinimum");
        Objects.requireNonNull(remoteSupported, "remoteSupported");
        LinkedHashSet<SchemaVersion> deduped = new LinkedHashSet<SchemaVersion>(remoteSupported);
        if (deduped.isEmpty()) {
            deduped.add(remoteAdvertised);
        }
        return new WalletSchemaMetadata(this.resolveNegotiatedVersion(List.copyOf(deduped), remoteMinimum), remoteAdvertised, remoteMinimum, List.copyOf(deduped), LOCAL_PREFERENCE);
    }
}

