/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.state;

import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import xyz.tcheeric.wallet.core.state.QuarantinedHistoryEvent;
import xyz.tcheeric.wallet.core.state.StoredVoucher;
import xyz.tcheeric.wallet.core.state.VoucherBackupState;
import xyz.tcheeric.wallet.core.state.WalletHistoryEvent;
import xyz.tcheeric.wallet.core.state.WalletSchemaMetadata;
import xyz.tcheeric.wallet.core.state.WalletToken;

public record WalletState(@Valid @NotNull WalletSchemaMetadata schema, @NotNull Instant exportedAt, List<@Valid WalletToken> tokens, List<@Valid WalletHistoryEvent> history, List<@Valid QuarantinedHistoryEvent> quarantined, @JsonProperty(value="encrypted_mnemonic") String encryptedMnemonic, @JsonProperty(value="deterministic_mode") Boolean deterministicMode, @JsonProperty(value="derivation_counters") Map<String, Integer> derivationCounters, List<@Valid StoredVoucher> vouchers, @JsonProperty(value="voucher_backup_state") VoucherBackupState voucherBackupState) {
    public WalletState(@Valid @NotNull WalletSchemaMetadata schema, @NotNull Instant exportedAt, List<WalletToken> tokens, List<WalletHistoryEvent> history, List<QuarantinedHistoryEvent> quarantined, @JsonProperty(value="encrypted_mnemonic") String encryptedMnemonic, @JsonProperty(value="deterministic_mode") Boolean deterministicMode, @JsonProperty(value="derivation_counters") Map<String, Integer> derivationCounters, List<StoredVoucher> vouchers, @JsonProperty(value="voucher_backup_state") VoucherBackupState voucherBackupState) {
        exportedAt = exportedAt == null ? Instant.now() : exportedAt;
        tokens = tokens == null ? List.of() : List.copyOf(tokens);
        history = history == null ? List.of() : List.copyOf(history);
        quarantined = quarantined == null ? List.of() : List.copyOf(quarantined);
        deterministicMode = deterministicMode != null ? deterministicMode : false;
        derivationCounters = derivationCounters == null ? Map.of() : Map.copyOf(derivationCounters);
        vouchers = vouchers == null ? List.of() : List.copyOf(vouchers);
        voucherBackupState = voucherBackupState == null ? new VoucherBackupState() : voucherBackupState;
    }

    public WalletState(WalletSchemaMetadata schema, Instant exportedAt, List<WalletToken> tokens, List<WalletHistoryEvent> history, List<QuarantinedHistoryEvent> quarantined) {
        this(schema, exportedAt, tokens, history, quarantined, null, false, null, null, null);
    }

    public boolean hasMnemonic() {
        return this.encryptedMnemonic != null && !this.encryptedMnemonic.isEmpty();
    }

    public boolean isDeterministic() {
        return Boolean.TRUE.equals(this.deterministicMode);
    }

    public int getDerivationCounter(String keysetId) {
        return this.derivationCounters.getOrDefault(keysetId, 0);
    }

    public WalletState withIncrementedCounter(String keysetId) {
        HashMap<String, Integer> newCounters = new HashMap<String, Integer>(this.derivationCounters);
        newCounters.put(keysetId, newCounters.getOrDefault(keysetId, 0) + 1);
        return new WalletState(this.schema, this.exportedAt, this.tokens, this.history, this.quarantined, this.encryptedMnemonic, this.deterministicMode, newCounters, this.vouchers, this.voucherBackupState);
    }

    public WalletState withEncryptedMnemonic(String encryptedMnemonic) {
        return new WalletState(this.schema, this.exportedAt, this.tokens, this.history, this.quarantined, encryptedMnemonic, true, this.derivationCounters, this.vouchers, this.voucherBackupState);
    }

    public WalletState withTokens(List<WalletToken> newTokens) {
        return new WalletState(this.schema, this.exportedAt, newTokens, this.history, this.quarantined, this.encryptedMnemonic, this.deterministicMode, this.derivationCounters, this.vouchers, this.voucherBackupState);
    }

    public WalletState withVouchers(List<StoredVoucher> newVouchers) {
        return new WalletState(this.schema, this.exportedAt, this.tokens, this.history, this.quarantined, this.encryptedMnemonic, this.deterministicMode, this.derivationCounters, newVouchers, this.voucherBackupState);
    }

    public WalletState withVoucherBackupState(VoucherBackupState newBackupState) {
        return new WalletState(this.schema, this.exportedAt, this.tokens, this.history, this.quarantined, this.encryptedMnemonic, this.deterministicMode, this.derivationCounters, this.vouchers, newBackupState);
    }
}

