/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.validation;

import java.util.Arrays;

final class Bech32 {
    private static final String CHARSET = "qpzry9x8gf2tvdw0s3jn54khce6mua7l";
    private static final int[] CHARSET_REV = new int[128];
    private static final int[] GENERATORS = new int[]{996825010, 642813549, 513874426, 1027748829, 705979059};

    private Bech32() {
    }

    static boolean containsOnlyCharset(String data) {
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch < CHARSET_REV.length && CHARSET_REV[ch] >= 0) continue;
            return false;
        }
        return true;
    }

    static boolean hasValidChecksum(String hrp, String data) {
        int[] values = new int[data.length()];
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch >= CHARSET_REV.length || CHARSET_REV[ch] < 0) {
                return false;
            }
            values[i] = CHARSET_REV[ch];
        }
        return Bech32.polymod(Bech32.hrpExpand(hrp), values) == 1;
    }

    private static int[] hrpExpand(String hrp) {
        int i;
        int[] expanded = new int[hrp.length() * 2 + 1];
        int idx = 0;
        for (i = 0; i < hrp.length(); ++i) {
            expanded[idx++] = hrp.charAt(i) >> 5;
        }
        expanded[idx++] = 0;
        for (i = 0; i < hrp.length(); ++i) {
            expanded[idx++] = hrp.charAt(i) & 0x1F;
        }
        return expanded;
    }

    private static int polymod(int[] hrpExpanded, int[] values) {
        int chk = 1;
        for (int v : Bech32.concatenate(hrpExpanded, values)) {
            int top = chk >>> 25;
            chk = (chk & 0x1FFFFFF) << 5 ^ v;
            for (int i = 0; i < GENERATORS.length; ++i) {
                if ((top >>> i & 1) != 1) continue;
                chk ^= GENERATORS[i];
            }
        }
        return chk;
    }

    private static int[] concatenate(int[] a, int[] b) {
        int[] result = Arrays.copyOf(a, a.length + b.length);
        System.arraycopy(b, 0, result, a.length, b.length);
        return result;
    }

    static {
        Arrays.fill(CHARSET_REV, -1);
        for (int i = 0; i < CHARSET.length(); ++i) {
            Bech32.CHARSET_REV[CHARSET.charAt((int)i)] = i;
        }
    }
}

