/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import java.io.FileInputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import lombok.Generated;
import xyz.tcheeric.wallet.core.StoragePaths;

public final class PollingConfig {
    private static final long DEFAULT_INTERVAL_MS = 1000L;
    private static final long DEFAULT_TIMEOUT_MS = 60000L;

    public static long mintIntervalMs() {
        return PollingConfig.resolve("WALLET_MINT_POLL_INTERVAL_MS", "mintPollIntervalMs", 1000L);
    }

    public static long mintTimeoutMs() {
        return PollingConfig.resolve("WALLET_MINT_POLL_TIMEOUT_MS", "mintPollTimeoutMs", 60000L);
    }

    public static long meltIntervalMs() {
        return PollingConfig.resolve("WALLET_MELT_POLL_INTERVAL_MS", "meltPollIntervalMs", 1000L);
    }

    public static long meltTimeoutMs() {
        return PollingConfig.resolve("WALLET_MELT_POLL_TIMEOUT_MS", "meltPollTimeoutMs", 60000L);
    }

    private static long resolve(String envKey, String propKey, long def) {
        try {
            String prop;
            String env = System.getenv(envKey);
            if (env != null && !env.isBlank()) {
                return Long.parseLong(env.trim());
            }
            Properties p = new Properties();
            Path path = StoragePaths.configFile();
            if (Files.exists(path, new LinkOption[0])) {
                try (FileInputStream is = new FileInputStream(path.toFile());){
                    p.load(is);
                }
            }
            if ((prop = p.getProperty(propKey)) != null && !prop.isBlank()) {
                return Long.parseLong(prop.trim());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return def;
    }

    @Generated
    private PollingConfig() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

