/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core;

import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Properties;
import xyz.tcheeric.wallet.core.StoragePaths;

public record WalletConfig(String defaultMintUrl, String defaultUnit) {
    public static WalletConfig fromEnv() {
        String mint = System.getenv().getOrDefault("MINT_URL", "http://localhost:7777");
        String unit = System.getenv().getOrDefault("DEFAULT_UNIT", "sat");
        return new WalletConfig(mint, unit);
    }

    public static WalletConfig load() {
        Properties p = new Properties();
        Path path = StoragePaths.configFile();
        if (Files.exists(path, new LinkOption[0])) {
            try (FileInputStream is = new FileInputStream(path.toFile());){
                p.load(is);
            }
            catch (IOException e) {
                throw new RuntimeException("Failed to read wallet config. I/O error while reading " + String.valueOf(path) + ". Suggestion: Check file permissions and existence of the config file, then retry.", e);
            }
        }
        String fileMint = p.getProperty("defaultMintUrl");
        String fileUnit = p.getProperty("defaultUnit");
        String mint = System.getenv().getOrDefault("MINT_URL", fileMint != null ? fileMint : "http://localhost:7777");
        String unit = System.getenv().getOrDefault("DEFAULT_UNIT", fileUnit != null ? fileUnit : "sat");
        return new WalletConfig(mint, unit);
    }
}

