/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.api;

import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.api.HttpRequestException;

@Deprecated(since="1.1.1", forRemoval=true)
class HttpClientHelper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpClientHelper.class);

    private HttpClientHelper() {
    }

    static String normalizeBase(String mintUrl) {
        Object url;
        Object object = url = mintUrl == null ? "" : mintUrl.trim();
        if (((String)url).isEmpty()) {
            url = "http://localhost:7777";
        }
        if (!((String)url).startsWith("http://") && !((String)url).startsWith("https://")) {
            url = "http://" + (String)url;
        }
        if (((String)url).endsWith("/")) {
            url = ((String)url).substring(0, ((String)url).length() - 1);
        }
        return url;
    }

    static HttpResponse<String> get(HttpClient client, Duration timeout, String url) throws HttpRequestException {
        HttpRequest req = HttpRequest.newBuilder(URI.create(url)).timeout(timeout).GET().build();
        String requestId = UUID.randomUUID().toString();
        long startNanos = System.nanoTime();
        try {
            log.debug("http_client request_started request_id={} method=GET url={} timeout_ms={}", new Object[]{requestId, url, timeout == null ? null : Long.valueOf(timeout.toMillis())});
            HttpResponse<String> resp = client.send(req, HttpResponse.BodyHandlers.ofString());
            HttpClientHelper.ensureSuccess(requestId, "GET", url, resp);
            log.debug("http_client request_completed request_id={} method=GET url={} status={} duration_ms={}", new Object[]{requestId, url, resp.statusCode(), HttpClientHelper.durationMillis(startNanos)});
            return resp;
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("http_client request_interrupted request_id={} method=GET url={} reason={} impact=request_aborted", new Object[]{requestId, url, e.toString(), e});
            throw new HttpRequestException("GET request interrupted", e);
        }
        catch (IOException e) {
            log.error("http_client request_failed request_id={} method=GET url={} reason={} impact=network_error", new Object[]{requestId, url, e.toString(), e});
            throw new HttpRequestException("GET request failed", e);
        }
    }

    static String postJson(HttpClient client, Duration timeout, String url, String body) throws HttpRequestException {
        HttpRequest req = HttpRequest.newBuilder(URI.create(url)).timeout(timeout).header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).build();
        String requestId = UUID.randomUUID().toString();
        long startNanos = System.nanoTime();
        try {
            log.debug("http_client request_started request_id={} method=POST url={} timeout_ms={} body_bytes={}", new Object[]{requestId, url, timeout == null ? null : Long.valueOf(timeout.toMillis()), body == null ? 0 : body.length()});
            HttpResponse<String> resp = client.send(req, HttpResponse.BodyHandlers.ofString());
            HttpClientHelper.ensureSuccess(requestId, "POST", url, resp);
            log.debug("http_client request_completed request_id={} method=POST url={} status={} duration_ms={}", new Object[]{requestId, url, resp.statusCode(), HttpClientHelper.durationMillis(startNanos)});
            return resp.body();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.error("http_client request_interrupted request_id={} method=POST url={} reason={} impact=request_aborted", new Object[]{requestId, url, e.toString(), e});
            throw new HttpRequestException("POST request interrupted", e);
        }
        catch (IOException e) {
            log.error("http_client request_failed request_id={} method=POST url={} reason={} impact=network_error", new Object[]{requestId, url, e.toString(), e});
            throw new HttpRequestException("POST request failed", e);
        }
    }

    private static long durationMillis(long startNanos) {
        return Math.max(0L, (System.nanoTime() - startNanos) / 1000000L);
    }

    private static void ensureSuccess(String requestId, String method, String url, HttpResponse<?> resp) throws HttpRequestException {
        if (resp.statusCode() < 200 || resp.statusCode() >= 300) {
            log.error("http_client request_failed request_id={} method={} url={} status={} impact=http_error", new Object[]{requestId, method, url, resp.statusCode()});
            throw new HttpRequestException(resp.request().method() + " " + url + " failed: HTTP " + resp.statusCode(), null);
        }
    }
}

