/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.http.HttpClient;
import java.net.http.HttpResponse;
import java.time.Duration;
import java.util.Map;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.cashu.entities.rest.GetActiveKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.GetKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateRequest;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteBolt11Request;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.wallet.core.ClientConfig;
import xyz.tcheeric.wallet.core.MintRegistry;
import xyz.tcheeric.wallet.core.api.HttpClientHelper;
import xyz.tcheeric.wallet.core.api.HttpRequestException;
import xyz.tcheeric.wallet.core.api.MintApi;
import xyz.tcheeric.wallet.core.api.MintApiException;
import xyz.tcheeric.wallet.core.api.MintApiMapper;
import xyz.tcheeric.wallet.core.api.MintInfoCache;

@Deprecated(since="1.1.1", forRemoval=true)
public class HttpMintApi
implements MintApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(HttpMintApi.class);
    private final String apiPrefix;
    private final HttpClient client;
    private final Duration timeout;
    private final MintApiMapper mapper;

    public HttpMintApi() {
        this(HttpClient.newHttpClient(), Duration.ofSeconds(5L), new MintApiMapper());
    }

    public HttpMintApi(HttpClient client, Duration timeout) {
        this(client, timeout, new MintApiMapper());
    }

    public HttpMintApi(HttpClient client, Duration timeout, MintApiMapper mapper) {
        this.client = client;
        this.timeout = timeout;
        this.mapper = mapper;
        String prefix = ClientConfig.apiPrefix();
        this.apiPrefix = prefix == null || prefix.isBlank() || "/".equals(prefix) ? "/v1" : prefix;
        log.debug("http_mint_api client_initialized api_prefix={}", (Object)this.apiPrefix);
    }

    @Override
    public MintApi.MintInfo info(String mintUrl) {
        String base = HttpClientHelper.normalizeBase(mintUrl);
        String endpoint = this.endpoint("/info");
        String url = base + endpoint;
        String callId = UUID.randomUUID().toString();
        log.debug("http_mint_api info_request_started call_id={} base_url={} endpoint={} url={}", new Object[]{callId, base, endpoint, url});
        try {
            HttpResponse<String> resp = HttpClientHelper.get(this.client, this.timeout, url);
            String body = resp.body();
            try {
                String[] candidates;
                JsonNode root = new ObjectMapper().readTree(body);
                for (String f : candidates = new String[]{"mintId", "mint_id", "id"}) {
                    String id;
                    JsonNode n = root.get(f);
                    if (n == null || !n.isTextual() || !(id = n.asText()).matches("[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}")) continue;
                    MintRegistry.putMint(base, id);
                    log.debug("http_mint_api mint_id_learned call_id={} base_url={} mint_id={}", new Object[]{callId, base, id});
                    break;
                }
            }
            catch (Exception root) {
                // empty catch block
            }
            MintApi.MintInfo info = this.mapper.parseMintInfo(base, body);
            MintInfoCache.save(base, resp.body());
            log.info("http_mint_api info_request_completed call_id={} base_url={} status={} cache_updated={} outcome=success", new Object[]{callId, base, resp.statusCode(), true});
            return info;
        }
        catch (HttpRequestException e) {
            log.error("http_mint_api info_request_failed call_id={} base_url={} endpoint={} reason={} impact=mint_unreachable", new Object[]{callId, base, endpoint, e.toString(), e});
            throw new MintApiException("Mint " + endpoint + " request failed", url, Map.of("mintUrl", mintUrl), e);
        }
        catch (IOException e) {
            log.error("http_mint_api info_request_failed call_id={} base_url={} endpoint={} reason={} impact=response_invalid", new Object[]{callId, base, endpoint, e.toString(), e});
            throw new MintApiException("Mint " + endpoint + " request failed", url, Map.of("mintUrl", mintUrl), e);
        }
    }

    @Override
    public MintApi.MintQuote quoteMint(String mintUrl, String unit, long amount) {
        String base = HttpClientHelper.normalizeBase(mintUrl);
        String method = this.chooseMethod(base, true, unit);
        String endpoint = this.endpoint("/mint/quote/" + method);
        String url = base + endpoint;
        String callId = UUID.randomUUID().toString();
        try {
            PostMintQuoteRequest reqObj = new PostMintQuoteRequest((int)amount, unit);
            String body = this.mapper.write(reqObj);
            log.debug("http_mint_api mint_quote_request_started call_id={} base_url={} endpoint={} unit={} amount={} method={}", new Object[]{callId, base, endpoint, unit, amount, method});
            String resp = HttpClientHelper.postJson(this.client, this.timeout, url, body);
            MintApi.MintQuote quote = this.mapper.parseMintQuote(unit, amount, resp);
            log.info("http_mint_api mint_quote_request_completed call_id={} base_url={} quote_id={} unit={} amount={} outcome=success", new Object[]{callId, base, quote.quoteId(), quote.unit(), quote.amount()});
            return quote;
        }
        catch (HttpRequestException e) {
            log.error("http_mint_api mint_quote_request_failed call_id={} base_url={} endpoint={} unit={} amount={} reason={} impact=mint_unreachable", new Object[]{callId, base, endpoint, unit, amount, e.toString(), e});
            throw new MintApiException("Failed to request mint quote", url, Map.of("unit", unit, "amount", amount), e);
        }
        catch (IOException e) {
            log.error("http_mint_api mint_quote_request_failed call_id={} base_url={} endpoint={} unit={} amount={} reason={} impact=response_invalid", new Object[]{callId, base, endpoint, unit, amount, e.toString(), e});
            throw new MintApiException("Failed to request mint quote", url, Map.of("unit", unit, "amount", amount), e);
        }
    }

    @Override
    public MintApi.MeltQuote quoteMelt(String mintUrl, String unit, long amount, String invoice) {
        String base = HttpClientHelper.normalizeBase(mintUrl);
        String method = this.chooseMethod(base, false, unit);
        String endpoint = this.endpoint("/melt/quote/" + method);
        String url = base + endpoint;
        String callId = UUID.randomUUID().toString();
        try {
            PostMeltQuoteBolt11Request reqObj = new PostMeltQuoteBolt11Request(invoice, unit);
            String body = this.mapper.write(reqObj);
            log.debug("http_mint_api melt_quote_request_started call_id={} base_url={} endpoint={} unit={} amount={} method={}", new Object[]{callId, base, endpoint, unit, amount, method});
            String resp = HttpClientHelper.postJson(this.client, this.timeout, url, body);
            MintApi.MeltQuote quote = this.mapper.parseMeltQuote(unit, amount, resp);
            log.info("http_mint_api melt_quote_request_completed call_id={} base_url={} quote_id={} unit={} amount={} fee_reserve={} outcome=success", new Object[]{callId, base, quote.quoteId(), quote.unit(), quote.amount(), quote.feeReserve()});
            return quote;
        }
        catch (HttpRequestException e) {
            log.error("http_mint_api melt_quote_request_failed call_id={} base_url={} endpoint={} unit={} amount={} reason={} impact=mint_unreachable", new Object[]{callId, base, endpoint, unit, amount, e.toString(), e});
            throw new MintApiException("Failed to request melt quote", url, Map.of("unit", unit, "amount", amount, "invoice", invoice), e);
        }
        catch (IOException e) {
            log.error("http_mint_api melt_quote_request_failed call_id={} base_url={} endpoint={} unit={} amount={} reason={} impact=response_invalid", new Object[]{callId, base, endpoint, unit, amount, e.toString(), e});
            throw new MintApiException("Failed to request melt quote", url, Map.of("unit", unit, "amount", amount, "invoice", invoice), e);
        }
    }

    @Override
    public boolean mintQuotePaid(String mintUrl, String unit, String quoteId) {
        String base = HttpClientHelper.normalizeBase(mintUrl);
        String method = this.chooseMethod(base, true, unit);
        String endpoint = this.endpoint("/mint/quote/" + method + "/" + quoteId);
        String url = base + endpoint;
        String callId = UUID.randomUUID().toString();
        try {
            HttpResponse<String> resp = HttpClientHelper.get(this.client, this.timeout, url);
            boolean paid = this.mapper.isPaid(resp.body());
            log.debug("http_mint_api mint_quote_status_checked call_id={} base_url={} quote_id={} paid={} outcome=evaluated", new Object[]{callId, base, quoteId, paid});
            return paid;
        }
        catch (Exception e) {
            log.warn("http_mint_api mint_quote_status_failed call_id={} base_url={} quote_id={} reason={} outcome=treated_unpaid", new Object[]{callId, base, quoteId, e.toString(), e});
            return false;
        }
    }

    @Override
    public GetActiveKeySetsResponse activeKeysets(String mintUrl) {
        String base = HttpClientHelper.normalizeBase(mintUrl);
        String endpoint = this.endpoint("/keysets");
        String url = base + endpoint;
        String callId = UUID.randomUUID().toString();
        log.debug("http_mint_api active_keysets_request_started call_id={} base_url={} endpoint={} url={}", new Object[]{callId, base, endpoint, url});
        try {
            HttpResponse<String> resp = HttpClientHelper.get(this.client, this.timeout, url);
            GetActiveKeySetsResponse response = this.mapper.parseActiveKeysets(resp.body());
            log.info("http_mint_api active_keysets_request_completed call_id={} base_url={} status={} outcome=success", new Object[]{callId, base, resp.statusCode()});
            return response;
        }
        catch (HttpRequestException e) {
            log.error("http_mint_api active_keysets_request_failed call_id={} base_url={} endpoint={} reason={} impact=mint_unreachable", new Object[]{callId, base, endpoint, e.toString(), e});
            throw new MintApiException(endpoint + " request failed", url, Map.of("mintUrl", mintUrl), e);
        }
        catch (IOException e) {
            log.error("http_mint_api active_keysets_request_failed call_id={} base_url={} endpoint={} reason={} impact=response_invalid", new Object[]{callId, base, endpoint, e.toString(), e});
            throw new MintApiException(endpoint + " request failed", url, Map.of("mintUrl", mintUrl), e);
        }
    }

    @Override
    public GetKeySetsResponse keyset(String mintUrl, String keysetId) {
        String base = HttpClientHelper.normalizeBase(mintUrl);
        String endpoint = this.endpoint("/keys/" + keysetId);
        String url = base + endpoint;
        String callId = UUID.randomUUID().toString();
        log.debug("http_mint_api keyset_request_started call_id={} base_url={} endpoint={} keyset_id={} url={}", new Object[]{callId, base, endpoint, keysetId, url});
        try {
            HttpResponse<String> resp = HttpClientHelper.get(this.client, this.timeout, url);
            GetKeySetsResponse response = this.mapper.parseKeyset(resp.body());
            log.info("http_mint_api keyset_request_completed call_id={} base_url={} keyset_id={} status={} outcome=success", new Object[]{callId, base, keysetId, resp.statusCode()});
            return response;
        }
        catch (HttpRequestException e) {
            log.error("http_mint_api keyset_request_failed call_id={} base_url={} keyset_id={} endpoint={} reason={} impact=mint_unreachable", new Object[]{callId, base, keysetId, endpoint, e.toString(), e});
            throw new MintApiException(endpoint + " request failed", url, Map.of("mintUrl", mintUrl, "keysetId", keysetId), e);
        }
        catch (IOException e) {
            log.error("http_mint_api keyset_request_failed call_id={} base_url={} keyset_id={} endpoint={} reason={} impact=response_invalid", new Object[]{callId, base, keysetId, endpoint, e.toString(), e});
            throw new MintApiException(endpoint + " request failed", url, Map.of("mintUrl", mintUrl, "keysetId", keysetId), e);
        }
    }

    @Override
    public PostMintResponse mint(String mintUrl, String quoteId, String unit, PostMintRequest<?> request) {
        String base = HttpClientHelper.normalizeBase(mintUrl);
        String method = this.chooseMethod(base, true, unit);
        String endpoint = this.endpoint("/mint/" + method);
        String url = base + endpoint;
        if (request.getQuoteId() == null) {
            request.setQuoteId(quoteId);
        }
        String callId = UUID.randomUUID().toString();
        try {
            String body = this.mapper.write(request);
            log.debug("http_mint_api mint_request_started call_id={} base_url={} endpoint={} quote_id={} unit={} method={} payload_proof_count={}", new Object[]{callId, base, endpoint, quoteId, unit, method, request.getBlindedMessages() == null ? 0 : request.getBlindedMessages().size()});
            String resp = HttpClientHelper.postJson(this.client, this.timeout, url, body);
            PostMintResponse response = this.mapper.parseMintResponse(resp);
            log.info("http_mint_api mint_request_completed call_id={} base_url={} quote_id={} outcome=success", new Object[]{callId, base, quoteId});
            return response;
        }
        catch (HttpRequestException e) {
            log.error("http_mint_api mint_request_failed call_id={} base_url={} endpoint={} quote_id={} reason={} impact=mint_unreachable", new Object[]{callId, base, endpoint, quoteId, e.toString(), e});
            throw new MintApiException("POST " + endpoint + " failed", url, Map.of("quoteId", quoteId), e);
        }
        catch (IOException e) {
            log.error("http_mint_api mint_request_failed call_id={} base_url={} endpoint={} quote_id={} reason={} impact=response_invalid", new Object[]{callId, base, endpoint, quoteId, e.toString(), e});
            throw new MintApiException("POST " + endpoint + " failed", url, Map.of("quoteId", quoteId), e);
        }
    }

    @Override
    public PostMeltResponse melt(String mintUrl, String quoteId, String unit, PostMeltRequest<?> request) {
        String base = HttpClientHelper.normalizeBase(mintUrl);
        String method = this.chooseMethod(base, false, unit);
        String endpoint = this.endpoint("/melt/" + method);
        String url = base + endpoint;
        if (request.getQuoteId() == null) {
            request.setQuoteId(quoteId);
        }
        String callId = UUID.randomUUID().toString();
        try {
            String body = this.mapper.write(request);
            log.debug("http_mint_api melt_request_started call_id={} base_url={} endpoint={} quote_id={} unit={} method={} token_count={}", new Object[]{callId, base, endpoint, quoteId, unit, method, request.getInputs() == null ? 0 : request.getInputs().size()});
            String resp = HttpClientHelper.postJson(this.client, this.timeout, url, body);
            PostMeltResponse response = this.mapper.parseMeltResponse(resp);
            log.info("http_mint_api melt_request_completed call_id={} base_url={} quote_id={} outcome=success", new Object[]{callId, base, quoteId});
            return response;
        }
        catch (HttpRequestException e) {
            log.error("http_mint_api melt_request_failed call_id={} base_url={} endpoint={} quote_id={} reason={} impact=mint_unreachable", new Object[]{callId, base, endpoint, quoteId, e.toString(), e});
            throw new MintApiException("POST " + endpoint + " failed", url, Map.of("quoteId", quoteId), e);
        }
        catch (IOException e) {
            log.error("http_mint_api melt_request_failed call_id={} base_url={} endpoint={} quote_id={} reason={} impact=response_invalid", new Object[]{callId, base, endpoint, quoteId, e.toString(), e});
            throw new MintApiException("POST " + endpoint + " failed", url, Map.of("quoteId", quoteId), e);
        }
    }

    @Override
    public boolean meltQuotePaid(String mintUrl, String unit, String quoteId) {
        String base = HttpClientHelper.normalizeBase(mintUrl);
        String method = this.chooseMethod(base, false, unit);
        String endpoint = this.endpoint("/melt/quote/" + method + "/" + quoteId);
        String url = base + endpoint;
        String callId = UUID.randomUUID().toString();
        try {
            HttpResponse<String> resp = HttpClientHelper.get(this.client, this.timeout, url);
            boolean paid = this.mapper.isPaid(resp.body());
            log.debug("http_mint_api melt_quote_status_checked call_id={} base_url={} quote_id={} paid={} outcome=evaluated", new Object[]{callId, base, quoteId, paid});
            return paid;
        }
        catch (Exception e) {
            log.warn("http_mint_api melt_quote_status_failed call_id={} base_url={} quote_id={} reason={} outcome=treated_unpaid", new Object[]{callId, base, quoteId, e.toString(), e});
            return false;
        }
    }

    @Override
    public PostSwapResponse swap(String mintUrl, PostSwapRequest<?> request) {
        String base = HttpClientHelper.normalizeBase(mintUrl);
        String endpoint = this.endpoint("/swap");
        String url = base + endpoint;
        String callId = UUID.randomUUID().toString();
        try {
            String body = this.mapper.write(request);
            log.debug("http_mint_api swap_request_started call_id={} base_url={} endpoint={} input_count={}", new Object[]{callId, base, endpoint, request.getInputs() == null ? 0 : request.getInputs().size()});
            String resp = HttpClientHelper.postJson(this.client, this.timeout, url, body);
            PostSwapResponse response = this.mapper.parseSwapResponse(resp);
            log.info("http_mint_api swap_request_completed call_id={} base_url={} outcome=success", (Object)callId, (Object)base);
            return response;
        }
        catch (HttpRequestException e) {
            log.error("http_mint_api swap_request_failed call_id={} base_url={} endpoint={} reason={} impact=mint_unreachable", new Object[]{callId, base, endpoint, e.toString(), e});
            throw new MintApiException("POST " + endpoint + " failed", url, Map.of("mintUrl", mintUrl), e);
        }
        catch (IOException e) {
            log.error("http_mint_api swap_request_failed call_id={} base_url={} endpoint={} reason={} impact=response_invalid", new Object[]{callId, base, endpoint, e.toString(), e});
            throw new MintApiException("POST " + endpoint + " failed", url, Map.of("mintUrl", mintUrl), e);
        }
    }

    @Override
    public PostCheckStateResponse check(String mintUrl, PostCheckStateRequest request) {
        String base = HttpClientHelper.normalizeBase(mintUrl);
        String endpoint = this.endpoint("/checkstate");
        String url = base + endpoint;
        String callId = UUID.randomUUID().toString();
        try {
            String body = this.mapper.write(request);
            log.debug("http_mint_api check_request_started call_id={} base_url={} endpoint={} payload_present={}", new Object[]{callId, base, endpoint, request != null});
            String resp = HttpClientHelper.postJson(this.client, this.timeout, url, body);
            PostCheckStateResponse response = this.mapper.parseCheckResponse(resp);
            log.info("http_mint_api check_request_completed call_id={} base_url={} outcome=success", (Object)callId, (Object)base);
            return response;
        }
        catch (HttpRequestException e) {
            log.error("http_mint_api check_request_failed call_id={} base_url={} endpoint={} reason={} impact=mint_unreachable", new Object[]{callId, base, endpoint, e.toString(), e});
            throw new MintApiException("POST " + endpoint + " failed", url, Map.of(), e);
        }
        catch (IOException e) {
            log.error("http_mint_api check_request_failed call_id={} base_url={} endpoint={} reason={} impact=response_invalid", new Object[]{callId, base, endpoint, e.toString(), e});
            throw new MintApiException("POST " + endpoint + " failed", url, Map.of(), e);
        }
    }

    private String chooseMethod(String base, boolean forMint, String unit) {
        String m;
        String cached;
        try {
            cached = MintInfoCache.load(base);
            if (cached != null && (m = this.mapper.pickMethodForUnit(cached, forMint, unit)) != null) {
                return m;
            }
        }
        catch (Exception e) {
            log.debug("http_mint_api method_selection_cache_failed base_url={} unit={} for_mint={} reason={} outcome=refresh", new Object[]{base, unit, forMint, e.toString(), e});
        }
        try {
            this.info(base);
            cached = MintInfoCache.load(base);
            if (cached != null && (m = this.mapper.pickMethodForUnit(cached, forMint, unit)) != null) {
                return m;
            }
        }
        catch (Exception e) {
            log.warn("http_mint_api method_selection_refresh_failed base_url={} unit={} for_mint={} reason={} outcome=default", new Object[]{base, unit, forMint, e.toString(), e});
        }
        return "bolt11";
    }

    private String endpoint(String path) {
        if (!((String)path).startsWith("/")) {
            path = "/" + (String)path;
        }
        return this.apiPrefix + (String)path;
    }
}

