/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.api;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import xyz.tcheeric.wallet.core.StoragePaths;

public final class MintInfoCache {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintInfoCache.class);
    private static final ObjectMapper MAPPER = new ObjectMapper();

    private static Path cacheFile() {
        return StoragePaths.walletHome().resolve("mint-info.json");
    }

    public static void save(String base, String infoJson) {
        try {
            ObjectNode root;
            StoragePaths.ensureDirs();
            Path path = MintInfoCache.cacheFile();
            Object object = root = Files.exists(path, new LinkOption[0]) ? MAPPER.readTree(Files.readString(path)) : MAPPER.createObjectNode();
            if (!root.isObject()) {
                root = MAPPER.createObjectNode();
            }
            root.set(base, MAPPER.readTree(infoJson));
            Files.writeString(path, (CharSequence)MAPPER.writerWithDefaultPrettyPrinter().writeValueAsString((Object)root), new OpenOption[0]);
        }
        catch (IOException e) {
            log.error("mint_info_cache write_failed base={} path={} reason={} impact=cache_not_persisted", new Object[]{base, MintInfoCache.cacheFile(), e.toString(), e});
        }
    }

    public static String load(String base) {
        try {
            Path path = MintInfoCache.cacheFile();
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            JsonNode root = MAPPER.readTree(Files.readString(path));
            JsonNode node = root.get(base);
            return node == null ? null : node.toString();
        }
        catch (IOException e) {
            log.warn("mint_info_cache read_failed base={} path={} reason={} outcome=cache_ignored", new Object[]{base, MintInfoCache.cacheFile(), e.toString(), e});
            return null;
        }
    }
}

