/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.api.adapter;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.resilience4j.circuitbreaker.CallNotPermittedException;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ThreadLocalRandom;
import lombok.Generated;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;
import xyz.tcheeric.cashu.common.PaymentMethod;
import xyz.tcheeric.cashu.entities.rest.GetActiveKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.GetKeySetsResponse;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateRequest;
import xyz.tcheeric.cashu.entities.rest.PostCheckStateResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMeltRequest;
import xyz.tcheeric.cashu.entities.rest.PostMeltResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintQuoteResponse;
import xyz.tcheeric.cashu.entities.rest.PostMintRequest;
import xyz.tcheeric.cashu.entities.rest.PostMintResponse;
import xyz.tcheeric.cashu.entities.rest.PostSwapRequest;
import xyz.tcheeric.cashu.entities.rest.PostSwapResponse;
import xyz.tcheeric.cashu.wallet.client.impl.RequestActiveKeysets;
import xyz.tcheeric.cashu.wallet.client.impl.RequestCheckMeltQuoteState;
import xyz.tcheeric.cashu.wallet.client.impl.RequestCheckMintQuoteState;
import xyz.tcheeric.cashu.wallet.client.impl.RequestCheckState;
import xyz.tcheeric.cashu.wallet.client.impl.RequestKeySetPublicKey;
import xyz.tcheeric.cashu.wallet.client.impl.RequestMeltQuote;
import xyz.tcheeric.cashu.wallet.client.impl.RequestMeltToken;
import xyz.tcheeric.cashu.wallet.client.impl.RequestMintQuote;
import xyz.tcheeric.cashu.wallet.client.impl.RequestMintToken;
import xyz.tcheeric.cashu.wallet.client.impl.RequestSwapToken;
import xyz.tcheeric.wallet.core.ClientConfig;
import xyz.tcheeric.wallet.core.api.MintApi;
import xyz.tcheeric.wallet.core.api.MintApiException;
import xyz.tcheeric.wallet.core.api.MintInfoCache;
import xyz.tcheeric.wallet.core.api.MintInvoiceNotPaidException;

public class CashuWalletMintApi
implements MintApi {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(CashuWalletMintApi.class);
    @NonNull
    private final RestTemplate restTemplate;
    private static final String DEFAULT_SUGGESTION = "Check network connectivity, verify the mint URL and parameters, then retry";
    private static final ObjectMapper JSON = new ObjectMapper();
    private static final String MINT_INVOICE_NOT_PAID_ERROR = "mint_invoice_not_paid_error";
    private static final CircuitBreakerConfig DEFAULT_CB_CONFIG = CircuitBreakerConfig.custom().failureRateThreshold(50.0f).slidingWindowSize(20).permittedNumberOfCallsInHalfOpenState(3).waitDurationInOpenState(Duration.ofSeconds(10L)).slowCallRateThreshold(100.0f).slowCallDurationThreshold(Duration.ofSeconds(5L)).build();
    private static final ConcurrentHashMap<String, CircuitBreaker> BREAKERS = new ConcurrentHashMap();

    static String normalizeApiBase(String mintUrl) {
        Objects.requireNonNull(mintUrl, "mintUrl must not be null");
        String trimmed = mintUrl.trim();
        if (trimmed.isEmpty()) {
            throw new IllegalArgumentException("mintUrl must not be blank");
        }
        while (trimmed.endsWith("/")) {
            trimmed = trimmed.substring(0, trimmed.length() - 1);
        }
        String prefix = ClientConfig.apiPrefix();
        if (trimmed.endsWith(prefix)) {
            return trimmed;
        }
        return trimmed + prefix;
    }

    private MintApiException fail(String what, String why, String suggestion, String mintUrl, Map<String, Object> ctx, Exception cause) {
        String msg = String.format("%s. %s. Suggestion: %s.", what, why, suggestion);
        return new MintApiException(msg, Objects.toString(mintUrl, ""), ctx, cause);
    }

    private static CircuitBreaker breakerFor(String mintUrl, String op) {
        String name = "mint-" + mintUrl + "#" + op;
        return BREAKERS.computeIfAbsent(name, n -> CircuitBreaker.of((String)n, (CircuitBreakerConfig)DEFAULT_CB_CONFIG));
    }

    private static boolean isRetryable(RestClientException e) {
        if (e instanceof HttpStatusCodeException) {
            HttpStatusCodeException ex = (HttpStatusCodeException)e;
            int code = ex.getStatusCode().value();
            if (code >= 500) {
                return true;
            }
            return code == 429;
        }
        String msg = e.getMessage() == null ? "" : e.getMessage().toLowerCase();
        return msg.contains("connection") || msg.contains("timeout") || msg.contains("refused") || msg.contains("unavailable");
    }

    private static void sleepBackoff(long baseMillis, int attempt) {
        long backoff = (long)((double)baseMillis * Math.pow(2.0, attempt));
        long jitter = ThreadLocalRandom.current().nextLong(0L, 50L);
        long delay = Math.min(2000L, backoff + jitter);
        try {
            Thread.sleep(delay);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * Loose catch block
     */
    private <T> T execWithResilience(String mintUrl, String op, Callable<T> call) {
        CircuitBreaker breaker = CashuWalletMintApi.breakerFor(mintUrl, op);
        int maxAttempts = 3;
        int attempt = 0;
        while (true) {
            try {
                return (T)CircuitBreaker.decorateCallable((CircuitBreaker)breaker, call).call();
            }
            catch (CallNotPermittedException open) {
                String what = String.format("%s failed due to circuit open: mintUrl=%s", op, mintUrl);
                String why = "Circuit breaker is OPEN for this mint (recent failures)";
                throw this.fail(what, why, "Wait a few seconds and retry; if persistent, try a different mint", mintUrl, Map.of(), (Exception)((Object)open));
            }
            catch (RestClientException rce) {
                if (++attempt < maxAttempts && CashuWalletMintApi.isRetryable(rce)) {
                    CashuWalletMintApi.sleepBackoff(200L, attempt);
                    continue;
                }
                throw rce;
            }
            break;
        }
        catch (Exception ex) {
            throw new RestClientException("Mint client execution failed", (Throwable)ex);
        }
    }

    @Override
    public MintApi.MintInfo info(String mintUrl) {
        log.debug("Fetching mint info from: {}", (Object)mintUrl);
        try {
            String apiBaseUrl = CashuWalletMintApi.normalizeApiBase(mintUrl);
            String infoUrl = apiBaseUrl + "/info";
            Map response = this.execWithResilience(mintUrl, "info", () -> (Map)this.restTemplate.getForObject(infoUrl, Map.class, new Object[0]));
            if (response == null) {
                throw new MintApiException("Mint info returned null response", mintUrl, Map.of(), null);
            }
            try {
                String raw = JSON.writeValueAsString((Object)response);
                MintInfoCache.save(mintUrl, raw);
            }
            catch (Exception e) {
                log.warn("Failed to save mint info cache for {}: {}", (Object)mintUrl, (Object)e.toString());
            }
            List<String> units = response.getOrDefault("units", List.of());
            Map<String, Object> keysets = response.getOrDefault("keysets", Map.of());
            List<String> mintMethods = response.getOrDefault("mint_methods", List.of());
            List<String> meltMethods = response.getOrDefault("melt_methods", List.of());
            return new MintApi.MintInfo(mintUrl, units, keysets, mintMethods, meltMethods);
        }
        catch (RestClientException e) {
            String what = String.format("Failed to fetch mint info: mintUrl=%s", mintUrl);
            ErrorMapper.Details details = ErrorMapper.from(e);
            log.error("{} \u2014 {}", new Object[]{what, details.message, e});
            throw this.fail(what, details.message, details.suggestion, mintUrl, Map.of(), (Exception)((Object)e));
        }
    }

    @Override
    public MintApi.MintQuote quoteMint(String mintUrl, String unit, long amount) {
        log.debug("Requesting mint quote: mintUrl={}, unit={}, amount={}", new Object[]{mintUrl, unit, amount});
        try {
            int requestAmount = this.toMintRequestAmount(mintUrl, unit, amount);
            PostMintQuoteRequest request = new PostMintQuoteRequest(requestAmount, unit);
            String apiBaseUrl = CashuWalletMintApi.normalizeApiBase(mintUrl);
            PostMintQuoteResponse response = this.execWithResilience(mintUrl, "quoteMint", () -> {
                RequestMintQuote requestMintQuote = new RequestMintQuote(apiBaseUrl, PaymentMethod.BOLT11, request);
                return (PostMintQuoteResponse)requestMintQuote.execute();
            });
            String rawJson = this.serializeToJson(response);
            long quotedAmount = amount;
            return new MintApi.MintQuote(response.getQuoteId(), quotedAmount, unit, rawJson);
        }
        catch (RestClientException e) {
            String what = String.format("Failed to request mint quote: mintUrl=%s, unit=%s, amount=%d", mintUrl, unit, amount);
            ErrorMapper.Details details = ErrorMapper.from(e);
            log.error("{} \u2014 {}", new Object[]{what, details.message, e});
            throw this.fail(what, details.message, details.suggestion, mintUrl, Map.of("unit", unit, "amount", amount), (Exception)((Object)e));
        }
        catch (Exception e) {
            String what = String.format("Unexpected error requesting mint quote: mintUrl=%s, unit=%s, amount=%d", mintUrl, unit, amount);
            String why = String.format("Unhandled exception: %s", e.getMessage());
            log.error("{} \u2014 {}", new Object[]{what, why, e});
            throw this.fail(what, why, DEFAULT_SUGGESTION, mintUrl, Map.of("unit", unit, "amount", amount), e);
        }
    }

    private int toMintRequestAmount(String mintUrl, String unit, long amount) {
        try {
            return Math.toIntExact(amount);
        }
        catch (ArithmeticException e) {
            String what = String.format("Invalid mint amount: mintUrl=%s, unit=%s, amount=%d", mintUrl, unit, amount);
            String why = "Amount exceeds maximum supported value (2,147,483,647 sats)";
            String suggestion = "Use a smaller amount or split the mint into multiple quotes";
            log.error("{} \u2014 {}", new Object[]{what, why, e});
            throw this.fail(what, why, suggestion, mintUrl, Map.of("unit", unit, "amount", amount), e);
        }
    }

    @Override
    public MintApi.MeltQuote quoteMelt(String mintUrl, String unit, long amount, String invoice) {
        log.debug("Requesting melt quote: mintUrl={}, unit={}, amount={}, invoice={}", new Object[]{mintUrl, unit, amount, invoice});
        try {
            PostMeltQuoteRequest request = new PostMeltQuoteRequest(invoice);
            String apiBaseUrl = CashuWalletMintApi.normalizeApiBase(mintUrl);
            PostMeltQuoteResponse response = this.execWithResilience(mintUrl, "quoteMelt", () -> {
                RequestMeltQuote requestMeltQuote = new RequestMeltQuote(apiBaseUrl, PaymentMethod.BOLT11, request);
                return (PostMeltQuoteResponse)requestMeltQuote.execute();
            });
            String rawJson = this.serializeToJson(response);
            return new MintApi.MeltQuote(response.getQuoteId(), response.getAmount(), unit, response.getFeeReserve(), rawJson);
        }
        catch (RestClientException e) {
            String what = String.format("Failed to request melt quote: mintUrl=%s, unit=%s, invoice=%s", mintUrl, unit, invoice);
            ErrorMapper.Details details = ErrorMapper.from(e);
            log.error("{} \u2014 {}", new Object[]{what, details.message, e});
            throw this.fail(what, details.message, details.suggestion, mintUrl, Map.of("unit", unit, "invoice", invoice), (Exception)((Object)e));
        }
    }

    @Override
    public GetActiveKeySetsResponse activeKeysets(String mintUrl) {
        log.debug("Fetching active keysets from: {}", (Object)mintUrl);
        try {
            String apiBaseUrl = CashuWalletMintApi.normalizeApiBase(mintUrl);
            return this.execWithResilience(mintUrl, "activeKeysets", () -> {
                RequestActiveKeysets request = new RequestActiveKeysets(apiBaseUrl);
                return (GetActiveKeySetsResponse)request.execute();
            });
        }
        catch (RestClientException e) {
            String what = String.format("Failed to fetch active keysets: mintUrl=%s", mintUrl);
            ErrorMapper.Details details = ErrorMapper.from(e);
            log.error("{} \u2014 {}", new Object[]{what, details.message, e});
            throw this.fail(what, details.message, details.suggestion, mintUrl, Map.of(), (Exception)((Object)e));
        }
    }

    @Override
    public GetKeySetsResponse keyset(String mintUrl, String keysetId) {
        log.debug("Fetching keyset: mintUrl={}, keysetId={}", (Object)mintUrl, (Object)keysetId);
        try {
            String apiBaseUrl = CashuWalletMintApi.normalizeApiBase(mintUrl);
            return this.execWithResilience(mintUrl, "keyset", () -> {
                RequestKeySetPublicKey request = new RequestKeySetPublicKey(apiBaseUrl, keysetId);
                return (GetKeySetsResponse)request.execute();
            });
        }
        catch (RestClientException e) {
            String what = String.format("Failed to fetch keyset: mintUrl=%s, keysetId=%s", mintUrl, keysetId);
            ErrorMapper.Details details = ErrorMapper.from(e);
            log.error("{} \u2014 {}", new Object[]{what, details.message, e});
            throw this.fail(what, details.message, details.suggestion, mintUrl, Map.of("keysetId", keysetId), (Exception)((Object)e));
        }
    }

    @Override
    public PostMintResponse mint(String mintUrl, String quoteId, String unit, PostMintRequest<?> request) {
        log.debug("Minting tokens: mintUrl={}, quoteId={}, unit={}", new Object[]{mintUrl, quoteId, unit});
        try {
            String apiBaseUrl = CashuWalletMintApi.normalizeApiBase(mintUrl);
            return this.execWithResilience(mintUrl, "mint", () -> {
                RequestMintToken requestMintToken = new RequestMintToken(apiBaseUrl, PaymentMethod.BOLT11, request);
                return (PostMintResponse)requestMintToken.execute();
            });
        }
        catch (RestClientException e) {
            String what = String.format("Failed to mint tokens: mintUrl=%s, quoteId=%s, unit=%s", mintUrl, quoteId, unit);
            ErrorMapper.Details details = ErrorMapper.from(e);
            if (details.code != null && details.code.equalsIgnoreCase(MINT_INVOICE_NOT_PAID_ERROR)) {
                log.warn("{} \u2014 {}", (Object)what, (Object)details.message);
                throw new MintInvoiceNotPaidException(mintUrl, quoteId, unit, details.message, e);
            }
            log.error("{} \u2014 {}", new Object[]{what, details.message, e});
            throw this.fail(what, details.message, details.suggestion, mintUrl, Map.of("quoteId", quoteId, "unit", unit), (Exception)((Object)e));
        }
    }

    @Override
    public boolean mintQuotePaid(String mintUrl, String unit, String quoteId) {
        log.debug("Checking mint quote paid: mintUrl={}, unit={}, quoteId={}", new Object[]{mintUrl, unit, quoteId});
        try {
            String apiBaseUrl = CashuWalletMintApi.normalizeApiBase(mintUrl);
            PostMintQuoteResponse response = this.execWithResilience(mintUrl, "mintQuotePaid", () -> {
                RequestCheckMintQuoteState request = new RequestCheckMintQuoteState(apiBaseUrl, quoteId, "bolt11");
                return (PostMintQuoteResponse)request.execute();
            });
            return response.isPaid();
        }
        catch (RestClientException e) {
            String what = String.format("Failed to check mint quote state: mintUrl=%s, unit=%s, quoteId=%s", mintUrl, unit, quoteId);
            ErrorMapper.Details details = ErrorMapper.from(e);
            log.error("{} \u2014 {}", new Object[]{what, details.message, e});
            throw this.fail(what, details.message, details.suggestion, mintUrl, Map.of("unit", unit, "quoteId", quoteId), (Exception)((Object)e));
        }
    }

    @Override
    public PostMeltResponse melt(String mintUrl, String quoteId, String unit, PostMeltRequest<?> request) {
        log.debug("Melting tokens: mintUrl={}, quoteId={}, unit={}", new Object[]{mintUrl, quoteId, unit});
        try {
            String apiBaseUrl = CashuWalletMintApi.normalizeApiBase(mintUrl);
            return this.execWithResilience(mintUrl, "melt", () -> {
                RequestMeltToken requestMeltToken = new RequestMeltToken(apiBaseUrl, PaymentMethod.BOLT11, request);
                return (PostMeltResponse)requestMeltToken.execute();
            });
        }
        catch (RestClientException e) {
            String what = String.format("Failed to melt tokens: mintUrl=%s, quoteId=%s, unit=%s", mintUrl, quoteId, unit);
            ErrorMapper.Details details = ErrorMapper.from(e);
            log.error("{} \u2014 {}", new Object[]{what, details.message, e});
            throw this.fail(what, details.message, details.suggestion, mintUrl, Map.of("quoteId", quoteId, "unit", unit), (Exception)((Object)e));
        }
    }

    @Override
    public boolean meltQuotePaid(String mintUrl, String unit, String quoteId) {
        log.debug("Checking melt quote paid: mintUrl={}, unit={}, quoteId={}", new Object[]{mintUrl, unit, quoteId});
        try {
            String apiBaseUrl = CashuWalletMintApi.normalizeApiBase(mintUrl);
            PostMeltQuoteResponse response = this.execWithResilience(mintUrl, "meltQuotePaid", () -> {
                RequestCheckMeltQuoteState request = new RequestCheckMeltQuoteState(apiBaseUrl, quoteId, "bolt11");
                return (PostMeltQuoteResponse)request.execute();
            });
            return response.isPaid();
        }
        catch (RestClientException e) {
            String what = String.format("Failed to check melt quote state: mintUrl=%s, unit=%s, quoteId=%s", mintUrl, unit, quoteId);
            ErrorMapper.Details details = ErrorMapper.from(e);
            log.error("{} \u2014 {}", new Object[]{what, details.message, e});
            throw this.fail(what, details.message, details.suggestion, mintUrl, Map.of("unit", unit, "quoteId", quoteId), (Exception)((Object)e));
        }
    }

    @Override
    public PostSwapResponse swap(String mintUrl, PostSwapRequest<?> request) {
        log.debug("Swapping tokens: mintUrl={}", (Object)mintUrl);
        try {
            String apiBaseUrl = CashuWalletMintApi.normalizeApiBase(mintUrl);
            return this.execWithResilience(mintUrl, "swap", () -> {
                RequestSwapToken requestSwapToken = new RequestSwapToken(apiBaseUrl, request);
                return (PostSwapResponse)requestSwapToken.execute();
            });
        }
        catch (RestClientException e) {
            String what = String.format("Failed to swap tokens: mintUrl=%s", mintUrl);
            ErrorMapper.Details details = ErrorMapper.from(e);
            log.error("{} \u2014 {}", new Object[]{what, details.message, e});
            throw this.fail(what, details.message, details.suggestion, mintUrl, Map.of(), (Exception)((Object)e));
        }
    }

    @Override
    public PostCheckStateResponse check(String mintUrl, PostCheckStateRequest request) {
        log.debug("Checking proof states: mintUrl={}", (Object)mintUrl);
        try {
            String apiBaseUrl = CashuWalletMintApi.normalizeApiBase(mintUrl);
            return this.execWithResilience(mintUrl, "check", () -> {
                RequestCheckState requestCheckState = new RequestCheckState(apiBaseUrl, request);
                return (PostCheckStateResponse)requestCheckState.execute();
            });
        }
        catch (RestClientException e) {
            String what = String.format("Failed to check proof states: mintUrl=%s", mintUrl);
            ErrorMapper.Details details = ErrorMapper.from(e);
            log.error("{} \u2014 {}", new Object[]{what, details.message, e});
            throw this.fail(what, details.message, details.suggestion, mintUrl, Map.of(), (Exception)((Object)e));
        }
    }

    private String serializeToJson(Object object) {
        try {
            return JSON.writeValueAsString(object);
        }
        catch (Exception e) {
            log.warn("Failed to serialize response to JSON: {}", (Object)e.getMessage());
            return "{}";
        }
    }

    @Generated
    public CashuWalletMintApi(@NonNull RestTemplate restTemplate) {
        if (restTemplate == null) {
            throw new NullPointerException("restTemplate is marked non-null but is null");
        }
        this.restTemplate = restTemplate;
    }

    static final class ErrorMapper {
        static final String CODE = "code";
        static final String ERROR = "error";
        static final String MESSAGE = "message";
        static final String DETAIL = "detail";
        static final String REASON = "reason";

        ErrorMapper() {
        }

        static Details from(RestClientException e) {
            String body = null;
            Object status = e.getMessage();
            if (e instanceof HttpStatusCodeException) {
                HttpStatusCodeException ex = (HttpStatusCodeException)e;
                body = ex.getResponseBodyAsString();
                status = ex.getStatusCode().value() + " " + ex.getStatusText();
            }
            String code = null;
            String message = null;
            if (body != null && !body.isBlank()) {
                try {
                    JsonNode node = JSON.readTree(body);
                    if (node.hasNonNull(CODE)) {
                        code = ErrorMapper.safeText(node.get(CODE).asText());
                    }
                    if (node.hasNonNull(ERROR)) {
                        message = ErrorMapper.safeText(node.get(ERROR).asText());
                    }
                    if (message == null && node.hasNonNull(MESSAGE)) {
                        message = ErrorMapper.safeText(node.get(MESSAGE).asText());
                    }
                    if (message == null && node.hasNonNull(DETAIL)) {
                        message = ErrorMapper.safeText(node.get(DETAIL).asText());
                    }
                    if (message == null && node.hasNonNull(REASON)) {
                        message = ErrorMapper.safeText(node.get(REASON).asText());
                    }
                }
                catch (Exception node) {
                    // empty catch block
                }
            }
            String suggestion = ErrorMapper.suggestionFor(code);
            String why = code != null ? String.format("HTTP client error: %s (mint_error_code=%s%s)", status, code, message != null ? ", reason=" + message : "") : String.format("HTTP client error: %s", status);
            return new Details(code, why, suggestion);
        }

        static String suggestionFor(String code) {
            String c;
            if (code == null) {
                return CashuWalletMintApi.DEFAULT_SUGGESTION;
            }
            return switch (c = code.trim().toUpperCase()) {
                case "QUOTE_EXPIRED" -> "Request a new quote and complete the payment within 5 minutes, then retry the operation";
                case "LIGHTNING_FAILURE", "PAYMENT_FAILED" -> "Wait a moment and retry; if it persists, verify the invoice and try a different mint or contact the operator";
                case "INVALID_CHANGE" -> "Do not proceed with spending; retry later and contact the mint operator to report the issue";
                case "UNAUTHORIZED", "AUTH_FAILED" -> "Check your authentication or access credentials for the mint and retry";
                default -> CashuWalletMintApi.DEFAULT_SUGGESTION;
            };
        }

        private static String safeText(String s) {
            return s == null || s.isBlank() ? null : s;
        }

        static class Details {
            final String code;
            final String message;
            final String suggestion;

            Details(String code, String message, String suggestion) {
                this.code = code;
                this.message = message;
                this.suggestion = suggestion;
            }
        }
    }
}

