/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.api.adapter;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class MintApiErrorHandler
extends DefaultResponseErrorHandler {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MintApiErrorHandler.class);
    private static final int MAX_BODY_LOG_SIZE = 1024;

    public void handleError(ClientHttpResponse response) throws IOException {
        HttpStatus statusCode = HttpStatus.resolve((int)response.getRawStatusCode());
        String statusText = response.getStatusText();
        String responseBody = this.getResponseBodyAsString(response);
        if (statusCode != null && statusCode.is4xxClientError()) {
            this.logClientError(statusCode, statusText, responseBody);
        } else if (statusCode != null && statusCode.is5xxServerError()) {
            this.logServerError(statusCode, statusText, responseBody);
        } else {
            this.logUnknownError(response.getRawStatusCode(), statusText, responseBody);
        }
        super.handleError(response);
    }

    private void logClientError(HttpStatus status, String statusText, String body) {
        log.warn("mint_api_client_error status={} status_text='{}' body='{}'", new Object[]{status.value(), statusText, this.truncateForLog(body)});
        switch (status) {
            case BAD_REQUEST: {
                log.warn("mint_api_bad_request detail='Request format invalid or required fields missing'");
                break;
            }
            case UNAUTHORIZED: {
                log.warn("mint_api_unauthorized detail='Authentication required (check NUT-98 support)'");
                break;
            }
            case NOT_FOUND: {
                log.warn("mint_api_not_found detail='Endpoint or quote not found (may have expired)'");
                break;
            }
            case TOO_MANY_REQUESTS: {
                log.warn("mint_api_rate_limited detail='Too many requests, retry with backoff'");
                break;
            }
        }
    }

    private void logServerError(HttpStatus status, String statusText, String body) {
        log.error("mint_api_server_error status={} status_text='{}' body='{}' action='Consider retry with backoff'", new Object[]{status.value(), statusText, this.truncateForLog(body)});
        switch (status) {
            case INTERNAL_SERVER_ERROR: {
                log.error("mint_api_internal_error detail='Mint server error, may be transient'");
                break;
            }
            case SERVICE_UNAVAILABLE: {
                log.error("mint_api_unavailable detail='Mint temporarily unavailable, retry later'");
                break;
            }
            case GATEWAY_TIMEOUT: {
                log.error("mint_api_timeout detail='Mint response timeout, operation may have succeeded'");
                break;
            }
        }
    }

    private void logUnknownError(int statusCode, String statusText, String body) {
        log.error("mint_api_unknown_error status={} status_text='{}' body='{}'", new Object[]{statusCode, statusText, this.truncateForLog(body)});
    }

    private String getResponseBodyAsString(ClientHttpResponse response) {
        try {
            byte[] body = this.getResponseBody(response);
            if (body == null || body.length == 0) {
                return "(empty)";
            }
            return new String(body, StandardCharsets.UTF_8);
        }
        catch (Exception e) {
            log.warn("mint_api_error_handler failed_to_read_error_body reason={}", (Object)e.toString());
            return "(failed to read body: " + e.getMessage() + ")";
        }
    }

    private String truncateForLog(String body) {
        if (body == null) {
            return "(null)";
        }
        if (body.length() <= 1024) {
            return body;
        }
        return body.substring(0, 1024) + "... (truncated, total " + body.length() + " chars)";
    }
}

