/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.cashu;

import jakarta.validation.Valid;
import jakarta.validation.constraints.NotBlank;
import jakarta.validation.constraints.NotEmpty;
import jakarta.validation.constraints.Pattern;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import xyz.tcheeric.wallet.core.nostr.cashu.WalletHistoryEntry;

public final class WalletHistory {
    @NotBlank
    @Pattern(regexp="^[0-9a-f]{64}$", message="pubkey must be 64 lowercase hex")
    private final @NotBlank @Pattern(regexp="^[0-9a-f]{64}$", message="pubkey must be 64 lowercase hex") String authorPubkeyHex;
    private final String identifier;
    @NotBlank
    private final String version;
    @NotEmpty
    @Valid
    private final List<WalletHistoryEntry> entries;

    public WalletHistory(String authorPubkeyHex, String identifier, String version, List<WalletHistoryEntry> entries) {
        this.authorPubkeyHex = Objects.requireNonNull(authorPubkeyHex, "authorPubkeyHex").toLowerCase();
        this.identifier = identifier;
        this.version = Objects.requireNonNull(version, "version");
        this.entries = List.copyOf((Collection)Objects.requireNonNull(entries, "entries"));
    }

    public String authorPubkeyHex() {
        return this.authorPubkeyHex;
    }

    public String identifier() {
        return this.identifier;
    }

    public String version() {
        return this.version;
    }

    public List<WalletHistoryEntry> entries() {
        return Collections.unmodifiableList(this.entries);
    }
}

