/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.observability;

import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.DistributionSummary;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Timer;
import java.util.concurrent.atomic.AtomicLong;
import xyz.tcheeric.wallet.core.observability.spi.MetricsExtension;

public class CashuMetricsExtension
implements MetricsExtension {
    public void registerMetrics(MeterRegistry registry) {
        Counter.builder((String)"cashu.mint.quote.total").description("Total mint quote requests").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"cashu.mint.requests.total").description("Total mint API requests").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"cashu.mint.quote.success").description("Successful mint quote requests").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"cashu.mint.quote.failure").description("Failed mint quote requests").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"cashu.mint.success.total").description("Total successful mint operations").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"cashu.melt.quote.total").description("Total melt quote requests").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"cashu.melt.requests.total").description("Total melt API requests").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"cashu.melt.quote.success").description("Successful melt quote requests").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"cashu.melt.quote.failure").description("Failed melt quote requests").tag("application", "cashu-wallet").register(registry);
        Counter.builder((String)"cashu.melt.success.total").description("Total successful melt operations").tag("application", "cashu-wallet").register(registry);
        AtomicLong proofCount = new AtomicLong(0L);
        Gauge.builder((String)"cashu.proof.count", (Object)proofCount, AtomicLong::get).description("Current number of proofs in wallet").tag("application", "cashu-wallet").register(registry);
        AtomicLong proofPending = new AtomicLong(0L);
        Gauge.builder((String)"cashu.proof.pending", (Object)proofPending, AtomicLong::get).description("Number of pending proofs").tag("application", "cashu-wallet").register(registry);
        AtomicLong proofSpent = new AtomicLong(0L);
        Gauge.builder((String)"cashu.proof.spent", (Object)proofSpent, AtomicLong::get).description("Number of spent proofs").tag("application", "cashu-wallet").register(registry);
        Timer.builder((String)"cashu.token.selection.duration").description("Duration of token selection operations").tag("application", "cashu-wallet").register(registry);
        Timer.builder((String)"cashu.token.encoding.duration").description("Duration of token encoding operations").tag("application", "cashu-wallet").register(registry);
        Timer.builder((String)"cashu.token.decoding.duration").description("Duration of token decoding operations").tag("application", "cashu-wallet").register(registry);
        DistributionSummary.builder((String)"cashu.token.amount").description("Distribution of token amounts").tag("application", "cashu-wallet").baseUnit("satoshis").register(registry);
    }

    public String getName() {
        return "cashu";
    }

    public int getPriority() {
        return 100;
    }
}

