/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.proof;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import xyz.tcheeric.wallet.core.proof.ProofRecord;
import xyz.tcheeric.wallet.core.proof.Selection;

public final class ProofSelector {
    private ProofSelector() {
    }

    public static Optional<Selection> selectExact(List<ProofRecord> rows, long target) {
        ArrayList<ProofRecord> picked = new ArrayList<ProofRecord>();
        rows.sort((a, b) -> Integer.compare(b.amount(), a.amount()));
        if (ProofSelector.dfsExact(rows, 0, target, picked)) {
            long sum = picked.stream().mapToLong(ProofRecord::amount).sum();
            return Optional.of(new Selection(new ArrayList<ProofRecord>(picked), sum));
        }
        return Optional.empty();
    }

    private static boolean dfsExact(List<ProofRecord> rows, int idx, long target, List<ProofRecord> picked) {
        if (target == 0L) {
            return true;
        }
        if (idx >= rows.size() || target < 0L) {
            return false;
        }
        long remSum = 0L;
        for (int i = idx; i < rows.size(); ++i) {
            remSum += (long)rows.get(i).amount();
        }
        if (remSum < target) {
            return false;
        }
        picked.add(rows.get(idx));
        if (ProofSelector.dfsExact(rows, idx + 1, target - (long)rows.get(idx).amount(), picked)) {
            return true;
        }
        picked.remove(picked.size() - 1);
        return ProofSelector.dfsExact(rows, idx + 1, target, picked);
    }

    public static Optional<Selection> selectExactDP(List<ProofRecord> rows, long target) {
        int i;
        int MAX_DP_INPUTS = 2048;
        long MAX_DP_TARGET = 1000000L;
        if (rows.size() > 2048 || target <= 0L || target > 1000000L) {
            return Optional.empty();
        }
        int T = (int)target;
        int n = rows.size();
        boolean[] dp = new boolean[T + 1];
        int[] prevSum = new int[T + 1];
        int[] prevIdx = new int[T + 1];
        Arrays.fill(prevSum, -1);
        Arrays.fill(prevIdx, -1);
        dp[0] = true;
        for (int i2 = 0; i2 < n; ++i2) {
            int a = rows.get(i2).amount();
            for (int s = T; s >= a; --s) {
                if (dp[s] || !dp[s - a]) continue;
                dp[s] = true;
                prevSum[s] = s - a;
                prevIdx[s] = i2;
            }
        }
        if (!dp[T]) {
            return Optional.empty();
        }
        ArrayList<ProofRecord> picked = new ArrayList<ProofRecord>();
        int s = T;
        while (s > 0 && (i = prevIdx[s]) >= 0) {
            picked.add(rows.get(i));
            s = prevSum[s];
        }
        long sum = picked.stream().mapToLong(ProofRecord::amount).sum();
        return Optional.of(new Selection(picked, sum));
    }
}

