/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.token;

import java.util.ArrayList;
import java.util.Base64;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import org.bouncycastle.util.encoders.DecoderException;
import org.bouncycastle.util.encoders.Hex;
import xyz.tcheeric.cashu.common.TokenV4;
import xyz.tcheeric.wallet.core.token.TokenCodec;
import xyz.tcheeric.wallet.core.token.TokenDecodingException;
import xyz.tcheeric.wallet.core.token.TokenEnvelope;

public class TokenV4Codec
implements TokenCodec {
    @Override
    public String encode(TokenEnvelope envelope) throws TokenDecodingException {
        Objects.requireNonNull(envelope, "envelope");
        if (envelope.mintUrl() == null || envelope.mintUrl().isBlank()) {
            throw new IllegalArgumentException("mintUrl is blank");
        }
        if (envelope.unit() == null || envelope.unit().isBlank()) {
            throw new IllegalArgumentException("unit is blank");
        }
        try {
            TokenV4 token = new TokenV4();
            token.setMintUrl(envelope.mintUrl());
            token.setUnit(envelope.unit());
            LinkedHashMap<String, TokenV4.TokenData> groupedByKeyset = new LinkedHashMap<String, TokenV4.TokenData>();
            for (TokenEnvelope.TokenProof proof : envelope.proofs()) {
                if (proof.amount() <= 0) {
                    throw new IllegalArgumentException("token proof amount must be positive");
                }
                String normalizedKeyset = proof.keysetId() == null ? "" : proof.keysetId();
                byte[] tmpKeysetBytes = null;
                String ksTrimmed = normalizedKeyset.trim();
                if (!ksTrimmed.isEmpty()) {
                    try {
                        tmpKeysetBytes = Hex.decode((String)ksTrimmed);
                    }
                    catch (DecoderException decoderException) {
                        // empty catch block
                    }
                }
                byte[] keysetBytes = tmpKeysetBytes;
                TokenV4.TokenData tokenData = groupedByKeyset.computeIfAbsent(normalizedKeyset, k -> {
                    TokenV4.TokenData data = new TokenV4.TokenData();
                    if (keysetBytes != null) {
                        data.setKeySetId(keysetBytes);
                    }
                    return data;
                });
                TokenV4.TokenData.TokenProof tokenProof = new TokenV4.TokenData.TokenProof();
                tokenProof.setAmount(Integer.valueOf(proof.amount()));
                tokenProof.setSecret(this.encodeSecret(proof.secret()));
                byte[] signature = this.decodeSignature(proof.cHex());
                if (signature != null) {
                    tokenProof.setSignature(signature);
                }
                tokenData.addProofs(new TokenV4.TokenData.TokenProof[]{tokenProof});
            }
            token.setTokenDataList(new ArrayList(groupedByKeyset.values()));
            return token.serialize(false);
        }
        catch (IllegalArgumentException e) {
            String lower;
            String msg = e.getMessage();
            String string = lower = msg == null ? "" : msg.toLowerCase();
            Object normalized = lower.contains("keyset") || lower.contains("key set") ? "token proof keyset id invalid" : (lower.contains("signature") ? "token proof missing signature" : (lower.contains("secret") || lower.contains("base64") ? "token secret is not valid Base64" : (msg == null || msg.isBlank() ? "token encode failed: unknown error" : "token encode failed: " + msg)));
            throw new TokenDecodingException((String)normalized, e);
        }
    }

    @Override
    public TokenEnvelope decode(String serialized) throws TokenDecodingException {
        if (serialized == null || serialized.isBlank()) {
            throw new TokenDecodingException("token is blank");
        }
        try {
            TokenV4 token = TokenV4.deserialize((String)serialized);
            String mintUrl = token.getMintUrl();
            if (mintUrl == null || mintUrl.isBlank()) {
                throw new TokenDecodingException("token missing mint url");
            }
            String unit = token.getUnit();
            if (unit == null || unit.isBlank()) {
                throw new TokenDecodingException("token missing unit");
            }
            List tokenData = token.getTokenDataList();
            if (tokenData == null || tokenData.isEmpty()) {
                throw new TokenDecodingException("token contains no proofs");
            }
            ArrayList<TokenEnvelope.TokenProof> proofs = new ArrayList<TokenEnvelope.TokenProof>();
            for (TokenV4.TokenData data : tokenData) {
                String keysetId = this.decodeKeysetId(data.getKeySetId());
                List proofList = data.getProofs();
                if (proofList == null || proofList.isEmpty()) continue;
                for (TokenV4.TokenData.TokenProof proof : proofList) {
                    proofs.add(new TokenEnvelope.TokenProof(proof.getAmount(), this.encodeSignature(proof.getSignature()), this.decodeSecret(proof.getSecret()), keysetId));
                }
            }
            if (proofs.isEmpty()) {
                throw new TokenDecodingException("token contains no proofs");
            }
            return new TokenEnvelope(mintUrl, unit, proofs);
        }
        catch (TokenDecodingException e) {
            throw e;
        }
        catch (Exception e) {
            String detail = e.getMessage();
            String reason = detail == null || detail.isBlank() ? "unknown error" : detail;
            throw new TokenDecodingException(reason, e);
        }
    }

    private byte[] requireKeysetId(String keysetId) {
        if (keysetId == null || keysetId.isBlank()) {
            throw new IllegalArgumentException("token proof missing keyset id");
        }
        try {
            return Hex.decode((String)keysetId.trim());
        }
        catch (DecoderException e) {
            throw new IllegalArgumentException("token proof keyset id is not valid hex", e);
        }
    }

    private String encodeSecret(byte[] secret) {
        if (secret == null || secret.length == 0) {
            return "";
        }
        return Base64.getEncoder().encodeToString(secret);
    }

    private byte[] decodeSignature(String cHex) {
        if (cHex == null || cHex.isBlank()) {
            return null;
        }
        try {
            return Hex.decode((String)cHex.trim());
        }
        catch (DecoderException e) {
            return null;
        }
    }

    private String decodeKeysetId(byte[] keysetBytes) throws TokenDecodingException {
        if (keysetBytes == null || keysetBytes.length == 0) {
            throw new TokenDecodingException("token missing keyset id");
        }
        return Hex.toHexString((byte[])keysetBytes);
    }

    private byte[] decodeSecret(String secret) throws TokenDecodingException {
        if (secret == null || secret.isBlank()) {
            return new byte[0];
        }
        try {
            return Base64.getDecoder().decode(secret);
        }
        catch (IllegalArgumentException e) {
            throw new TokenDecodingException("token secret is not valid Base64", e);
        }
    }

    private String encodeSignature(byte[] signature) throws TokenDecodingException {
        if (signature == null || signature.length == 0) {
            throw new TokenDecodingException("token proof missing signature");
        }
        return Hex.toHexString((byte[])signature);
    }
}

