/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.util;

public final class QuoteExpiryDetector {
    private static final String[] EXPIRY_INDICATORS = new String[]{"410", "gone", "expired"};

    private QuoteExpiryDetector() {
    }

    public static boolean isQuoteExpired(Throwable throwable) {
        for (Throwable current = throwable; current != null; current = current.getCause()) {
            String message = current.getMessage();
            if (message == null) continue;
            String lower = message.toLowerCase();
            for (String indicator : EXPIRY_INDICATORS) {
                if (!lower.contains(indicator)) continue;
                return true;
            }
        }
        return false;
    }
}

