-- Schema v2: add proofs table for detailed proof storage
CREATE TABLE IF NOT EXISTS proofs (
    id BIGINT GENERATED BY DEFAULT AS IDENTITY PRIMARY KEY,
    mint_url VARCHAR(512) NOT NULL,
    unit VARCHAR(32) NOT NULL,
    amount BIGINT NOT NULL,
    C TEXT NOT NULL,               -- commitment
    secret_enc BYTEA,              -- encrypted secret (future)
    dleq TEXT,                     -- dleq proof (optional)
    keyset_id VARCHAR(64) NOT NULL,
    p2pk_lock VARCHAR(128),
    spent BOOLEAN NOT NULL DEFAULT FALSE,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    spent_at TIMESTAMP
);

CREATE INDEX IF NOT EXISTS idx_proofs_mint_unit ON proofs(mint_url, unit);
CREATE INDEX IF NOT EXISTS idx_proofs_spent ON proofs(spent);
