/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr;

import java.time.Instant;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;

class NostrEventTest {
    NostrEventTest() {
    }

    @Test
    void deterministicIdStableForSameInputs() {
        Instant createdAt = Instant.ofEpochSecond(1700000000L);
        List<List<String>> tags = List.of(List.of("p", "npubexample"), List.of("amount", "100"));
        String first = NostrEvent.generateDeterministicId((String)"pubkey", (int)9321, (String)"{\"hello\":\"world\"}", tags, (Instant)createdAt);
        String second = NostrEvent.generateDeterministicId((String)"pubkey", (int)9321, (String)"{\"hello\":\"world\"}", tags, (Instant)createdAt);
        Assertions.assertEquals((Object)first, (Object)second);
    }

    @Test
    void deterministicIdChangesWithContent() {
        Instant createdAt = Instant.ofEpochSecond(1700000100L);
        List<List<String>> tags = List.of(List.of("p", "npubexample"));
        String original = NostrEvent.generateDeterministicId((String)"pubkey", (int)9321, (String)"original", tags, (Instant)createdAt);
        String modified = NostrEvent.generateDeterministicId((String)"pubkey", (int)9321, (String)"changed", tags, (Instant)createdAt);
        Assertions.assertNotEquals((Object)original, (Object)modified);
    }
}

