/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.InMemoryNostrRelayClient;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayConfig;
import xyz.tcheeric.wallet.core.nostr.NostrGatewayService;
import xyz.tcheeric.wallet.core.nostr.NostrRelayOption;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicy;
import xyz.tcheeric.wallet.core.nostr.relay.RelaySelectionPolicyType;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

class NostrGatewayServiceConcurrencyTest {
    NostrGatewayServiceConcurrencyTest() {
    }

    @Test
    void publishRemainsSafeDuringReloadAndClose() throws Exception {
        KeyPairGenerator generator = KeyPairGenerator.getInstance("Ed25519");
        KeyPair keyPair = generator.generateKeyPair();
        final IdentityKey identityKey = new IdentityKey(keyPair.getPrivate(), keyPair.getPublic());
        final WalletSigningKey walletSigningKey = new WalletSigningKey(new byte[]{1}, new byte[]{2}, new byte[]{3}, 1);
        IdentityKeyService identityKeyService = new IdentityKeyService(this){

            public synchronized IdentityKey loadOrCreate() {
                return identityKey;
            }
        };
        WalletKeyManager walletKeyManager = new WalletKeyManager(this, new SecureKeyStore(this){

            public Optional<byte[]> load(String alias) {
                return Optional.empty();
            }

            public void store(String alias, byte[] value) {
            }
        }){

            public synchronized WalletSigningKey loadOrCreate(IdentityKey ignored) {
                return walletSigningKey;
            }
        };
        List<NostrRelayOption> relaysA = List.of(new NostrRelayOption("ws://relay-a.example", false), new NostrRelayOption("ws://relay-b.example", true));
        List<NostrRelayOption> relaysB = List.of(new NostrRelayOption("ws://relay-c.example", false));
        AtomicReference<NostrGatewayConfig> configRef = new AtomicReference<NostrGatewayConfig>(new NostrGatewayConfig(relaysA));
        RelaySelectionPolicy policy = RelaySelectionPolicyType.STICKY.createPolicy();
        NostrGatewayService service = new NostrGatewayService(configRef::get, identityKeyService, walletKeyManager, (option, ignoredIdentityKey, ignoredWalletSigningKey) -> new InMemoryNostrRelayClient(option.url(), option.requiresAuth()), policy);
        service.start();
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicReference failure = new AtomicReference();
        CountDownLatch done = new CountDownLatch(2);
        Thread publisher = new Thread(() -> {
            try {
                NostrEvent event = new NostrEvent("id", "pub", 1, "content", Instant.now(), List.of(), null);
                while (running.get()) {
                    service.publish(event);
                }
            }
            catch (Throwable t) {
                failure.compareAndSet(null, t);
            }
            finally {
                done.countDown();
            }
        });
        Thread lifecycle = new Thread(() -> {
            try {
                for (int i = 0; i < 200; ++i) {
                    configRef.set(i % 2 == 0 ? new NostrGatewayConfig(relaysA) : new NostrGatewayConfig(relaysB));
                    service.reload();
                }
                service.close();
            }
            catch (Throwable t) {
                failure.compareAndSet(null, t);
            }
            finally {
                running.set(false);
                done.countDown();
            }
        });
        publisher.start();
        lifecycle.start();
        Assertions.assertTrue((boolean)done.await(10L, TimeUnit.SECONDS), (String)"Threads did not complete in time");
        publisher.join();
        lifecycle.join();
        Assertions.assertNull(failure.get(), () -> "Unexpected exception: " + String.valueOf(failure.get()));
    }
}

