/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class NostrTestFixtures {
    public static final String TRANSFER_EVENT_ID = "event-p2pk-fixture";
    public static final String TRANSFER_EVENT_RESOURCE = "nostr/p2pk-transfer.json";
    public static final String TRANSFER_ACK_OK_RESOURCE = "nostr/transfer-ack-ok.json";
    public static final String TRANSFER_ACK_DUPLICATE_RESOURCE = "nostr/transfer-ack-duplicate.json";
    private static final ObjectMapper MAPPER = new ObjectMapper();
    private static final String CANONICAL_RECIPIENT = NostrTestFixtures.jsonNode("nostr/p2pk-transfer.json").path("recipient").asText();

    private NostrTestFixtures() {
    }

    public static String canonicalJson(String resourceName) {
        String string;
        block8: {
            InputStream in = NostrTestFixtures.open(resourceName);
            try {
                JsonNode node = MAPPER.readTree(in);
                string = MAPPER.writeValueAsString((Object)node);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load Nostr fixture " + resourceName, e);
                }
            }
            in.close();
        }
        return string;
    }

    public static JsonNode jsonNode(String resourceName) {
        JsonNode jsonNode;
        block8: {
            InputStream in = NostrTestFixtures.open(resourceName);
            try {
                jsonNode = MAPPER.readTree(in);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load Nostr fixture " + resourceName, e);
                }
            }
            in.close();
        }
        return jsonNode;
    }

    public static String rawJson(String resourceName) {
        String string;
        block8: {
            InputStream in = NostrTestFixtures.open(resourceName);
            try {
                string = new String(in.readAllBytes(), StandardCharsets.UTF_8);
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to load Nostr fixture " + resourceName, e);
                }
            }
            in.close();
        }
        return string;
    }

    public static String transferRecipient() {
        return CANONICAL_RECIPIENT;
    }

    public static String canonicalize(String json) {
        try {
            JsonNode node = MAPPER.readTree(json);
            return MAPPER.writeValueAsString((Object)node);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to canonicalize JSON", e);
        }
    }

    private static InputStream open(String resourceName) {
        InputStream in = NostrTestFixtures.class.getClassLoader().getResourceAsStream(resourceName);
        return Objects.requireNonNull(in, "Missing Nostr fixture " + resourceName);
    }

    public static JsonNode parse(String json) {
        try {
            return MAPPER.readTree(json);
        }
        catch (IOException e) {
            throw new IllegalStateException("Failed to parse JSON", e);
        }
    }
}

