/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import java.time.Duration;
import java.util.Enumeration;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

@DisabledIfSystemProperty(named="noDocker", matches="true")
public abstract class BaseRelayAuthIntegrationTest {
    private static final Logger log = Logger.getLogger(BaseRelayAuthIntegrationTest.class.getName());
    private static final int RELAY_PORT = 8080;
    private static final String RESOURCE_BUNDLE = "relay-auth-container";
    private static final String IMAGE_KEY = "relay.container.image";
    private static GenericContainer<?> RELAY;
    protected static String relayUri;

    @BeforeAll
    static void ensureDockerAvailable() {
        boolean dockerAvailable = DockerClientFactory.instance().isDockerAvailable();
        if (!dockerAvailable) {
            log.warning("Docker is not available - auth relay integration tests will be skipped");
        }
        Assumptions.assumeTrue((boolean)dockerAvailable, (String)"Docker is required for auth relay tests");
        BaseRelayAuthIntegrationTest.ensureRelayContainerConfigured();
        if (!RELAY.isRunning()) {
            RELAY.start();
        }
        String host = RELAY.getHost();
        Integer mappedPort = RELAY.getMappedPort(8080);
        relayUri = String.format("ws://%s:%d", host, mappedPort);
        log.info("AUTH relay WebSocket URI: " + relayUri);
    }

    private static void ensureRelayContainerConfigured() {
        if (RELAY != null) {
            return;
        }
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
        String image = bundle.getString(IMAGE_KEY);
        log.info("Configuring AUTH-enabled Nostr relay container with image: " + image);
        GenericContainer container = new GenericContainer(image).withExposedPorts(new Integer[]{8080}).waitingFor((WaitStrategy)Wait.forListeningPort()).withStartupTimeout(Duration.ofSeconds(90L));
        Enumeration<String> keys = bundle.getKeys();
        String configResource = null;
        while (keys.hasMoreElements()) {
            String key = keys.nextElement();
            if (key.startsWith("env.")) {
                String envName = key.substring(4);
                container.withEnv(envName, bundle.getString(key));
                continue;
            }
            if (!key.equals("config.resource")) continue;
            configResource = bundle.getString(key);
        }
        if (configResource != null && !configResource.isBlank()) {
            String targetPath = "/app/relay-config.toml";
            container.withCopyFileToContainer(MountableFile.forClasspathResource((String)configResource), targetPath);
            container.withEnv("RELAY_CONFIG", targetPath);
        }
        RELAY = container;
        log.info("AUTH relay container configured");
    }

    protected static String getRelayUri() {
        return relayUri;
    }

    protected static GenericContainer<?> getRelayContainer() {
        return RELAY;
    }
}

