/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import java.time.Duration;
import java.util.ResourceBundle;
import java.util.logging.Logger;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import org.testcontainers.DockerClientFactory;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.TestcontainersConfiguration;

@DisabledIfSystemProperty(named="noDocker", matches="true")
public abstract class BaseRelayIntegrationTest {
    private static final Logger log = Logger.getLogger(BaseRelayIntegrationTest.class.getName());
    private static final int RELAY_PORT = 8080;
    private static final String RESOURCE_BUNDLE = "relay-container";
    private static final String IMAGE_KEY = "relay.container.image";
    private static GenericContainer<?> RELAY;
    protected static String relayUri;

    private static void ensureRelayContainerConfigured() {
        if (RELAY != null) {
            return;
        }
        boolean reuseEnabled = Boolean.parseBoolean(System.getProperty("testcontainers.reuse.enable", String.valueOf(TestcontainersConfiguration.getInstance().environmentSupportsReuse())));
        log.info("Testcontainers reuse enabled: " + reuseEnabled);
        ResourceBundle bundle = ResourceBundle.getBundle(RESOURCE_BUNDLE);
        String image = bundle.getString(IMAGE_KEY);
        log.info("Configuring singleton Nostr relay container with image: " + image);
        RELAY = new GenericContainer(image).withExposedPorts(new Integer[]{8080}).waitingFor((WaitStrategy)Wait.forListeningPort()).withStartupTimeout(Duration.ofSeconds(60L)).withReuse(true);
        log.info("Nostr relay container configured (singleton)");
    }

    @BeforeAll
    protected static void ensureDockerAvailable() {
        boolean dockerAvailable = DockerClientFactory.instance().isDockerAvailable();
        if (!dockerAvailable) {
            log.warning("Docker is not available - relay integration tests will be skipped");
        }
        Assumptions.assumeTrue((boolean)dockerAvailable, (String)"Docker is required to run nostr-rs-relay container for integration tests");
        BaseRelayIntegrationTest.ensureRelayContainerConfigured();
        if (!RELAY.isRunning()) {
            RELAY.start();
        }
        String host = RELAY.getHost();
        Integer mappedPort = RELAY.getMappedPort(8080);
        relayUri = String.format("ws://%s:%d", host, mappedPort);
        log.info("Nostr relay container started successfully");
        log.info("Relay WebSocket URI: " + relayUri);
    }

    protected static String getRelayUri() {
        return relayUri;
    }

    protected static GenericContainer<?> getRelayContainer() {
        return RELAY;
    }
}

