/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import java.time.Instant;
import java.util.List;
import net.jqwik.api.Arbitraries;
import net.jqwik.api.Arbitrary;
import net.jqwik.api.Combinators;
import net.jqwik.api.ForAll;
import net.jqwik.api.Property;
import net.jqwik.api.Provide;
import net.jqwik.api.arbitraries.ListArbitrary;
import net.jqwik.api.constraints.IntRange;
import nostr.event.impl.GenericEvent;
import org.junit.jupiter.api.Assertions;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrEventAdapter;

class NostrEventAdapterPropertyTest {
    NostrEventAdapterPropertyTest() {
    }

    @Property
    void roundtripConversionPreservesData(@ForAll(value="validNostrEvents") NostrEvent original) {
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)original);
        NostrEvent roundtrip = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        Assertions.assertNotNull((Object)roundtrip);
        Assertions.assertEquals((Object)original.id(), (Object)roundtrip.id());
        Assertions.assertEquals((Object)original.pubkey(), (Object)roundtrip.pubkey());
        Assertions.assertEquals((int)original.kind(), (int)roundtrip.kind());
        Assertions.assertEquals((Object)original.content(), (Object)roundtrip.content());
        Assertions.assertEquals((Object)original.createdAt(), (Object)roundtrip.createdAt());
        Assertions.assertEquals((Object)original.tags(), (Object)roundtrip.tags());
        Assertions.assertEquals((Object)original.sig(), (Object)roundtrip.sig());
    }

    @Property
    void nullInputReturnsNull() {
        Assertions.assertNull((Object)NostrEventAdapter.toNostrJavaEvent(null));
        Assertions.assertNull((Object)NostrEventAdapter.toWalletEvent(null));
    }

    @Property
    void toNostrJavaEventProducesNonNull(@ForAll(value="validNostrEvents") NostrEvent walletEvent) {
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)walletEvent);
        Assertions.assertNotNull((Object)nostrEvent);
    }

    @Property
    void tagCountIsPreserved(@ForAll(value="validNostrEvents") NostrEvent original) {
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)original);
        Assertions.assertEquals((int)original.tags().size(), (int)nostrEvent.getTags().size());
    }

    @Property
    void emptyTagsRemainEmpty(@ForAll(value="hexString64") String id, @ForAll(value="hexString64") String pubkey, @ForAll @IntRange(min=0, max=40000) @IntRange(min=0, max=40000) int kind, @ForAll String content, @ForAll(value="timestamps") Instant createdAt) {
        NostrEvent original = new NostrEvent(id, pubkey, kind, content, createdAt, List.of(), null);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)original);
        NostrEvent roundtrip = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        Assertions.assertTrue((boolean)roundtrip.tags().isEmpty());
    }

    @Property
    void timestampPrecisionTruncatedToSeconds(@ForAll(value="validNostrEvents") NostrEvent original) {
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)original);
        NostrEvent roundtrip = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        Assertions.assertEquals((long)original.createdAt().getEpochSecond(), (long)roundtrip.createdAt().getEpochSecond());
    }

    @Property
    void unsignedEventsRemainUnsigned(@ForAll(value="hexString64") String id, @ForAll(value="hexString64") String pubkey, @ForAll @IntRange(min=0, max=40000) @IntRange(min=0, max=40000) int kind, @ForAll String content, @ForAll(value="timestamps") Instant createdAt, @ForAll(value="tags") List<List<String>> tags) {
        NostrEvent original = new NostrEvent(id, pubkey, kind, content, createdAt, tags, null);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)original);
        NostrEvent roundtrip = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        Assertions.assertNull((Object)roundtrip.sig());
    }

    @Property
    void tagStructureIsPreserved(@ForAll(value="hexString64") String id, @ForAll(value="hexString64") String pubkey, @ForAll @IntRange(min=0, max=40000) @IntRange(min=0, max=40000) int kind, @ForAll String content, @ForAll(value="timestamps") Instant createdAt, @ForAll(value="tags") List<List<String>> tags, @ForAll(value="hexString128") String sig) {
        NostrEvent original = new NostrEvent(id, pubkey, kind, content, createdAt, tags, sig);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)original);
        NostrEvent roundtrip = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        for (int i = 0; i < tags.size(); ++i) {
            Assertions.assertEquals(tags.get(i), roundtrip.tags().get(i));
        }
    }

    @Provide
    Arbitrary<NostrEvent> validNostrEvents() {
        return Combinators.combine(this.hexString(64), this.hexString(64), (Arbitrary)Arbitraries.integers().between(0, 40000), (Arbitrary)Arbitraries.strings().alpha().ofMaxLength(1000), this.timestamps(), this.tags(), (Arbitrary)Arbitraries.oneOf((Arbitrary)Arbitraries.just(null), (Arbitrary[])new Arbitrary[]{this.hexString(128)})).as((id, pubkey, kind, content, createdAt, tagList, sig) -> new NostrEvent(id, pubkey, kind.intValue(), content, createdAt, tagList, sig));
    }

    @Provide
    Arbitrary<String> hexString(int length) {
        return Arbitraries.strings().withChars((CharSequence)"0123456789abcdef").ofLength(length);
    }

    @Provide
    Arbitrary<String> hexString64() {
        return this.hexString(64);
    }

    @Provide
    Arbitrary<String> hexString128() {
        return this.hexString(128);
    }

    @Provide
    Arbitrary<Instant> timestamps() {
        return Arbitraries.longs().between(0L, 2000000000L).map(Instant::ofEpochSecond);
    }

    @Provide
    Arbitrary<List<List<String>>> tags() {
        ListArbitrary tag = Arbitraries.strings().alpha().ofMaxLength(100).list().ofMinSize(1).ofMaxSize(5);
        return tag.list().ofMaxSize(10);
    }
}

