/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import java.time.Instant;
import java.util.List;
import nostr.base.ElementAttribute;
import nostr.base.PublicKey;
import nostr.event.BaseTag;
import nostr.event.impl.GenericEvent;
import nostr.event.tag.GenericTag;
import nostr.event.tag.IdentifierTag;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrEventAdapter;

class NostrEventAdapterTest {
    private static final String TEST_ID = "a".repeat(64);
    private static final String TEST_PUBKEY = "b".repeat(64);
    private static final String TEST_SIG = "c".repeat(128);
    private static final int TEST_KIND = 1;
    private static final String TEST_CONTENT = "Hello Nostr!";
    private static final Instant TEST_CREATED_AT = Instant.ofEpochSecond(1234567890L);
    private static final List<List<String>> TEST_TAGS = List.of(List.of("e", "event_id_hex", "wss://relay.example.com"), List.of("p", "pubkey_hex"), List.of("t", "nostr"));

    NostrEventAdapterTest() {
    }

    @Test
    void testToNostrJavaEvent_withFullEvent() {
        NostrEvent walletEvent = new NostrEvent(TEST_ID, TEST_PUBKEY, 1, TEST_CONTENT, TEST_CREATED_AT, TEST_TAGS, TEST_SIG);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)walletEvent);
        Assertions.assertNotNull((Object)nostrEvent);
        Assertions.assertEquals((Object)TEST_ID, (Object)nostrEvent.getId());
        Assertions.assertEquals((Object)TEST_PUBKEY, (Object)nostrEvent.getPubKey().toString());
        Assertions.assertEquals((int)1, (Integer)nostrEvent.getKind());
        Assertions.assertEquals((Object)TEST_CONTENT, (Object)nostrEvent.getContent());
        Assertions.assertEquals((long)TEST_CREATED_AT.getEpochSecond(), (Long)nostrEvent.getCreatedAt());
        Assertions.assertEquals((Object)TEST_SIG, (Object)nostrEvent.getSignature().toString());
        Assertions.assertNotNull((Object)nostrEvent.getTags());
        Assertions.assertEquals((int)3, (int)nostrEvent.getTags().size());
        Assertions.assertEquals((Object)"e", (Object)((BaseTag)nostrEvent.getTags().get(0)).getCode());
    }

    @Test
    void testToNostrJavaEvent_withUnsignedEvent() {
        NostrEvent walletEvent = new NostrEvent(TEST_ID, TEST_PUBKEY, 1, TEST_CONTENT, TEST_CREATED_AT, TEST_TAGS, null);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)walletEvent);
        Assertions.assertNotNull((Object)nostrEvent);
        Assertions.assertNull((Object)nostrEvent.getSignature());
    }

    @Test
    void testToNostrJavaEvent_withEmptyTags() {
        NostrEvent walletEvent = new NostrEvent(TEST_ID, TEST_PUBKEY, 1, TEST_CONTENT, TEST_CREATED_AT, List.of(), TEST_SIG);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)walletEvent);
        Assertions.assertNotNull((Object)nostrEvent);
        Assertions.assertNotNull((Object)nostrEvent.getTags());
        Assertions.assertTrue((boolean)nostrEvent.getTags().isEmpty());
    }

    @Test
    void testToNostrJavaEvent_withNull() {
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent(null);
        Assertions.assertNull((Object)nostrEvent);
    }

    @Test
    void testToWalletEvent_withFullEvent() {
        NostrEvent walletEvent = new NostrEvent(TEST_ID, TEST_PUBKEY, 1, TEST_CONTENT, TEST_CREATED_AT, TEST_TAGS, TEST_SIG);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)walletEvent);
        NostrEvent convertedEvent = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        Assertions.assertNotNull((Object)convertedEvent);
        Assertions.assertEquals((Object)TEST_ID, (Object)convertedEvent.id());
        Assertions.assertEquals((Object)TEST_PUBKEY, (Object)convertedEvent.pubkey());
        Assertions.assertEquals((int)1, (int)convertedEvent.kind());
        Assertions.assertEquals((Object)TEST_CONTENT, (Object)convertedEvent.content());
        Assertions.assertEquals((Object)TEST_CREATED_AT, (Object)convertedEvent.createdAt());
        Assertions.assertEquals((Object)TEST_SIG, (Object)convertedEvent.sig());
        Assertions.assertNotNull((Object)convertedEvent.tags());
        Assertions.assertEquals((int)3, (int)convertedEvent.tags().size());
        Assertions.assertEquals(List.of("e", "event_id_hex", "wss://relay.example.com"), convertedEvent.tags().get(0));
    }

    @Test
    void testToWalletEvent_withNull() {
        NostrEvent walletEvent = NostrEventAdapter.toWalletEvent(null);
        Assertions.assertNull((Object)walletEvent);
    }

    @Test
    void testRoundtripConversion_preservesData() {
        NostrEvent original = new NostrEvent(TEST_ID, TEST_PUBKEY, 1, TEST_CONTENT, TEST_CREATED_AT, TEST_TAGS, TEST_SIG);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)original);
        NostrEvent roundtrip = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        Assertions.assertNotNull((Object)roundtrip);
        Assertions.assertEquals((Object)original.id(), (Object)roundtrip.id());
        Assertions.assertEquals((Object)original.pubkey(), (Object)roundtrip.pubkey());
        Assertions.assertEquals((int)original.kind(), (int)roundtrip.kind());
        Assertions.assertEquals((Object)original.content(), (Object)roundtrip.content());
        Assertions.assertEquals((Object)original.createdAt(), (Object)roundtrip.createdAt());
        Assertions.assertEquals((Object)original.tags(), (Object)roundtrip.tags());
        Assertions.assertEquals((Object)original.sig(), (Object)roundtrip.sig());
    }

    @Test
    void testRoundtripConversion_withUnsignedEvent() {
        NostrEvent original = NostrEvent.unsigned((String)TEST_PUBKEY, (int)1, (String)TEST_CONTENT, (Instant)TEST_CREATED_AT, TEST_TAGS);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)original);
        NostrEvent roundtrip = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        Assertions.assertNotNull((Object)roundtrip);
        Assertions.assertNull((Object)roundtrip.sig());
        Assertions.assertEquals((Object)original.id(), (Object)roundtrip.id());
        Assertions.assertEquals((Object)original.pubkey(), (Object)roundtrip.pubkey());
        Assertions.assertEquals((Object)original.content(), (Object)roundtrip.content());
    }

    @Test
    void testTagConversion_withComplexTags() {
        List<List<String>> complexTags = List.of(List.of("e", "event1"), List.of("p", "pubkey1", "wss://relay1.com", "mention"), List.of("t", "bitcoin"), List.of("t", "nostr"), List.of("r", "https://example.com"));
        NostrEvent original = new NostrEvent(TEST_ID, TEST_PUBKEY, 1, TEST_CONTENT, TEST_CREATED_AT, complexTags, TEST_SIG);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)original);
        NostrEvent roundtrip = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        Assertions.assertEquals(complexTags, (Object)roundtrip.tags());
    }

    @Test
    void testTagConversion_withSingleElementTags() {
        List<List<String>> singleElementTags = List.of(List.of("t"), List.of("r"));
        NostrEvent original = new NostrEvent(TEST_ID, TEST_PUBKEY, 1, TEST_CONTENT, TEST_CREATED_AT, singleElementTags, TEST_SIG);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)original);
        NostrEvent roundtrip = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        Assertions.assertEquals(singleElementTags, (Object)roundtrip.tags());
    }

    @Test
    void testIdentifierTagPreservedThroughConversion() {
        GenericEvent nostrEvent = new GenericEvent();
        nostrEvent.setId(TEST_ID);
        nostrEvent.setPubKey(new PublicKey(TEST_PUBKEY));
        nostrEvent.setKind(Integer.valueOf(1));
        nostrEvent.setContent(TEST_CONTENT);
        nostrEvent.setCreatedAt(Long.valueOf(TEST_CREATED_AT.getEpochSecond()));
        nostrEvent.setTags(List.of(new IdentifierTag("default")));
        NostrEvent walletEvent = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        Assertions.assertNotNull((Object)walletEvent.tags());
        Assertions.assertEquals(List.of("d", "default"), walletEvent.tags().getFirst());
        GenericEvent convertedBack = NostrEventAdapter.toNostrJavaEvent((NostrEvent)walletEvent);
        Assertions.assertNotNull((Object)convertedBack.getTags());
        Assertions.assertEquals((int)1, (int)convertedBack.getTags().size());
        Assertions.assertEquals((Object)"d", (Object)((BaseTag)convertedBack.getTags().get(0)).getCode());
        Object e = convertedBack.getTags().get(0);
        if (e instanceof IdentifierTag) {
            IdentifierTag identifierTag = (IdentifierTag)e;
            Assertions.assertEquals((Object)"default", (Object)identifierTag.getUuid());
        } else {
            e = convertedBack.getTags().get(0);
            if (e instanceof GenericTag) {
                GenericTag genericTag = (GenericTag)e;
                List attrs = genericTag.getAttributes();
                Assertions.assertNotNull((Object)attrs);
                Assertions.assertFalse((boolean)attrs.isEmpty());
                Object value = ((ElementAttribute)attrs.get(0)).value();
                Assertions.assertEquals((Object)"default", (Object)(value != null ? value.toString() : null));
            } else {
                Assertions.fail((String)("Unexpected tag type: " + String.valueOf(((BaseTag)convertedBack.getTags().get(0)).getClass())));
            }
        }
    }

    @Test
    void testCreatedAtConversion_preservesSecondPrecision() {
        Instant timestamp = Instant.now();
        NostrEvent original = new NostrEvent(TEST_ID, TEST_PUBKEY, 1, TEST_CONTENT, timestamp, List.of(), TEST_SIG);
        GenericEvent nostrEvent = NostrEventAdapter.toNostrJavaEvent((NostrEvent)original);
        NostrEvent roundtrip = NostrEventAdapter.toWalletEvent((GenericEvent)nostrEvent);
        Assertions.assertEquals((long)timestamp.getEpochSecond(), (long)roundtrip.createdAt().getEpochSecond());
    }
}

