/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.time.Instant;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.condition.DisabledIfSystemProperty;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.adapter.BaseRelayAuthIntegrationTest;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrJavaRelayClient;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

@DisabledIfSystemProperty(named="wallet.nostr.auth.externalUrl", matches=".+")
class NostrJavaRelayClientAuthRelayIntegrationTest
extends BaseRelayAuthIntegrationTest {
    NostrJavaRelayClientAuthRelayIntegrationTest() {
    }

    @Test
    void clientAuthenticatesAndOperates() throws Exception {
        String relayUrl = NostrJavaRelayClientAuthRelayIntegrationTest.getRelayUri();
        NostrJavaRelayClient client = new NostrJavaRelayClient(relayUrl);
        IdentityKey identityKey = NostrJavaRelayClientAuthRelayIntegrationTest.generateIdentity();
        WalletSigningKey signingKey = NostrJavaRelayClientAuthRelayIntegrationTest.dummyWalletSigningKey();
        client.enableAuth(identityKey, signingKey);
        client.connect();
        Assertions.assertTrue((boolean)client.isConnected());
        NostrSubscription subscription = new NostrSubscription("auth-relay-sub", e -> true);
        AutoCloseable handle = client.subscribe(subscription, e -> {});
        String validDummyPubkey = "0".repeat(64);
        NostrEvent event = NostrEvent.unsigned((String)validDummyPubkey, (int)1, (String)"hello from auth relay", (Instant)Instant.now(), List.of());
        Assertions.assertDoesNotThrow(() -> client.publish(event));
        handle.close();
        client.close();
    }

    private static IdentityKey generateIdentity() throws Exception {
        KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
        keyGen.initialize(256);
        KeyPair pair = keyGen.generateKeyPair();
        return new IdentityKey(pair.getPrivate(), pair.getPublic());
    }

    private static WalletSigningKey dummyWalletSigningKey() {
        int i;
        byte[] priv = new byte[32];
        byte[] pub = new byte[32];
        byte[] salt = new byte[16];
        for (i = 0; i < 32; ++i) {
            priv[i] = (byte)i;
            pub[i] = (byte)(100 + i);
        }
        for (i = 0; i < 16; ++i) {
            salt[i] = (byte)(200 + i);
        }
        return new WalletSigningKey(priv, pub, salt, 1000);
    }
}

