/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.github.resilience4j.circuitbreaker.CircuitBreaker;
import io.github.resilience4j.circuitbreaker.CircuitBreakerConfig;
import java.io.IOException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.time.Instant;
import java.util.List;
import java.util.function.Consumer;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.adapter.BaseRelayIntegrationTest;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrJavaRelayClient;
import xyz.tcheeric.wallet.core.security.IdentityKey;
import xyz.tcheeric.wallet.core.security.WalletSigningKey;

class NostrJavaRelayClientIT
extends BaseRelayIntegrationTest {
    private static final ObjectMapper JSON_MAPPER = new ObjectMapper();
    private NostrJavaRelayClient client;

    NostrJavaRelayClientIT() {
    }

    @BeforeEach
    void setUp() {
    }

    @AfterEach
    void tearDown() {
        if (this.client != null && !this.isClosed(this.client)) {
            try {
                this.client.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        System.clearProperty("wallet.relay.circuitBreaker.failureRateThreshold");
        System.clearProperty("wallet.relay.circuitBreaker.windowType");
        System.clearProperty("wallet.relay.circuitBreaker.windowSize");
        System.clearProperty("wallet.relay.circuitBreaker.minimumCalls");
        System.clearProperty("wallet.relay.circuitBreaker.openWaitMs");
        System.clearProperty("wallet.relay.circuitBreaker.permittedHalfOpen");
    }

    private boolean isClosed(NostrJavaRelayClient client) {
        return !client.isConnected();
    }

    @Test
    void testConstructor_nullRelayUrl_throwsException() {
        Assertions.assertThrows(NullPointerException.class, () -> new NostrJavaRelayClient(null), (String)"Should throw NullPointerException for null relay URL");
    }

    @Test
    void testConstructor_blankRelayUrl_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new NostrJavaRelayClient("   "), (String)"Should throw IllegalArgumentException for blank relay URL");
    }

    @Test
    void testConstructor_emptyRelayUrl_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new NostrJavaRelayClient(""), (String)"Should throw IllegalArgumentException for empty relay URL");
    }

    @Test
    void testConstructor_validRelayUrl_createsClient() {
        this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
        Assertions.assertNotNull((Object)this.client, (String)"Client should be created");
        Assertions.assertEquals((Object)NostrJavaRelayClientIT.getRelayUri(), (Object)this.client.url(), (String)"URL should match");
        Assertions.assertFalse((boolean)this.client.isConnected(), (String)"Client should not be connected initially");
        Assertions.assertFalse((boolean)this.client.isAuthEnabled(), (String)"Auth should not be enabled initially");
        Assertions.assertNotNull((Object)this.client.getCircuitBreaker(), (String)"Circuit breaker should be created");
    }

    @Test
    void testUrl_returnsCorrectUrl() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            Assertions.assertEquals((Object)NostrJavaRelayClientIT.getRelayUri(), (Object)this.client.url(), (String)"URL should match constructor argument");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testIsConnected_initiallyFalse() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            Assertions.assertFalse((boolean)this.client.isConnected(), (String)"Client should not be connected initially");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testIsAuthEnabled_initiallyFalse() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            Assertions.assertFalse((boolean)this.client.isAuthEnabled(), (String)"Auth should not be enabled initially");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testConnect_successfullyConnects() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.connect();
            Assertions.assertTrue((boolean)this.client.isConnected(), (String)"Client should be connected after connect()");
        }
        catch (NostrJavaRelayClient.RelayConnectionException e) {
            System.err.println("Relay unreachable (expected in test): " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testConnect_isIdempotent() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.connect();
            this.client.connect();
            this.client.connect();
            Assertions.assertTrue((boolean)this.client.isConnected(), (String)"Client should be connected");
        }
        catch (NostrJavaRelayClient.RelayConnectionException e) {
            System.err.println("Relay unreachable (expected in test): " + e.getMessage());
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testConnect_afterClose_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.close();
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.connect(), (String)"Should throw IllegalStateException when connecting after close");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testEnableAuth_enablesAuthentication() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            IdentityKey identityKey = this.createTestIdentityKey();
            WalletSigningKey signingKey = this.createTestWalletSigningKey();
            this.client.enableAuth(identityKey, signingKey);
            Assertions.assertTrue((boolean)this.client.isAuthEnabled(), (String)"Auth should be enabled after enableAuth()");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testEnableAuth_nullIdentityKey_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            WalletSigningKey signingKey = this.createTestWalletSigningKey();
            Assertions.assertThrows(NullPointerException.class, () -> this.client.enableAuth(null, signingKey), (String)"Should throw NullPointerException for null identity key");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testEnableAuth_nullSigningKey_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            IdentityKey identityKey = this.createTestIdentityKey();
            Assertions.assertThrows(NullPointerException.class, () -> this.client.enableAuth(identityKey, null), (String)"Should throw NullPointerException for null signing key");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testEnableAuth_afterClose_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.close();
            IdentityKey identityKey = this.createTestIdentityKey();
            WalletSigningKey signingKey = this.createTestWalletSigningKey();
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.enableAuth(identityKey, signingKey), (String)"Should throw IllegalStateException when enabling auth after close");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testPublish_notConnected_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            NostrEvent event = this.createTestEvent();
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.publish(event), (String)"Should throw IllegalStateException when publishing without connecting");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testPublish_nullEvent_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.connect();
            Assertions.assertThrows(NullPointerException.class, () -> this.client.publish(null), (String)"Should throw NullPointerException for null event");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context/connection failure: " + e.getMessage());
        }
    }

    @Test
    void testPublish_afterClose_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.close();
            NostrEvent event = this.createTestEvent();
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.publish(event), (String)"Should throw IllegalStateException when publishing after close");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testSubscribe_notConnected_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            NostrSubscription subscription = this.createTestSubscription();
            Consumer<NostrEvent> consumer = event -> {};
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.subscribe(subscription, consumer), (String)"Should throw IllegalStateException when subscribing without connecting");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testSubscribe_nullSubscription_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.connect();
            Consumer<NostrEvent> consumer = event -> {};
            Assertions.assertThrows(NullPointerException.class, () -> this.client.subscribe(null, consumer), (String)"Should throw NullPointerException for null subscription");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context/connection failure: " + e.getMessage());
        }
    }

    @Test
    void testSubscribe_nullConsumer_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.connect();
            NostrSubscription subscription = this.createTestSubscription();
            Assertions.assertThrows(NullPointerException.class, () -> this.client.subscribe(subscription, null), (String)"Should throw NullPointerException for null consumer");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context/connection failure: " + e.getMessage());
        }
    }

    @Test
    void testSubscribe_afterClose_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.close();
            NostrSubscription subscription = this.createTestSubscription();
            Consumer<NostrEvent> consumer = event -> {};
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.subscribe(subscription, consumer), (String)"Should throw IllegalStateException when subscribing after close");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testDisconnect_successfullyDisconnects() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.connect();
            this.client.disconnect();
            Assertions.assertFalse((boolean)this.client.isConnected(), (String)"Client should be disconnected after disconnect()");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context/connection failure: " + e.getMessage());
        }
    }

    @Test
    void testDisconnect_isIdempotent() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.connect();
            this.client.disconnect();
            this.client.disconnect();
            this.client.disconnect();
            Assertions.assertFalse((boolean)this.client.isConnected(), (String)"Client should remain disconnected");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context/connection failure: " + e.getMessage());
        }
    }

    @Test
    void testDisconnect_afterClose_throwsException() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.close();
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.disconnect(), (String)"Should throw IllegalStateException when disconnecting after close");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testClose_successfullyCloses() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.connect();
            this.client.close();
            Assertions.assertFalse((boolean)this.client.isConnected(), (String)"Client should not be connected after close()");
            Assertions.assertTrue((boolean)this.client.getSpringContext().isClosed(), (String)"Spring context should be closed");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context/connection failure: " + e.getMessage());
        }
    }

    @Test
    void testClose_isIdempotent() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.connect();
            this.client.close();
            this.client.close();
            this.client.close();
            Assertions.assertFalse((boolean)this.client.isConnected(), (String)"Client should remain closed");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context/connection failure: " + e.getMessage());
        }
    }

    @Test
    void testClose_withoutConnect_succeeds() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.close();
            Assertions.assertFalse((boolean)this.client.isConnected(), (String)"Client should be closed");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testClose_preventsAllOperations() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            this.client.close();
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.connect());
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.disconnect());
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.enableAuth(this.createTestIdentityKey(), this.createTestWalletSigningKey()));
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.publish(this.createTestEvent()));
            Assertions.assertThrows(IllegalStateException.class, () -> this.client.subscribe(this.createTestSubscription(), event -> {}));
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testCircuitBreaker_defaultConfiguration() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            CircuitBreaker circuitBreaker = this.client.getCircuitBreaker();
            Assertions.assertNotNull((Object)circuitBreaker, (String)"Circuit breaker should be created");
            Assertions.assertEquals((Object)("relay-" + NostrJavaRelayClientIT.getRelayUri()), (Object)circuitBreaker.getName(), (String)"Circuit breaker name should include relay URL");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testCircuitBreaker_customConfiguration() {
        try {
            System.setProperty("wallet.relay.circuitBreaker.failureRateThreshold", "75");
            System.setProperty("wallet.relay.circuitBreaker.minimumCalls", "10");
            System.setProperty("wallet.relay.circuitBreaker.openWaitMs", "30000");
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            CircuitBreaker circuitBreaker = this.client.getCircuitBreaker();
            Assertions.assertNotNull((Object)circuitBreaker, (String)"Circuit breaker should be created");
            CircuitBreakerConfig config = circuitBreaker.getCircuitBreakerConfig();
            Assertions.assertEquals((double)75.0, (double)config.getFailureRateThreshold(), (double)0.1, (String)"Failure rate threshold should be customized");
            Assertions.assertEquals((int)10, (int)config.getMinimumNumberOfCalls(), (String)"Minimum calls should be customized");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testGetSpringContext_returnsContext() {
        try {
            this.client = new NostrJavaRelayClient(NostrJavaRelayClientIT.getRelayUri());
            Assertions.assertNotNull((Object)this.client.getSpringContext(), (String)"Spring context should not be null");
            Assertions.assertFalse((boolean)this.client.getSpringContext().isClosed(), (String)"Spring context should not be closed initially");
        }
        catch (Exception e) {
            System.err.println("Skipping test due to context creation failure: " + e.getMessage());
        }
    }

    @Test
    void testRelayConnectionException_properties() {
        IOException cause = new IOException("Connection refused");
        NostrJavaRelayClient.RelayConnectionException exception = new NostrJavaRelayClient.RelayConnectionException("Failed to connect to relay: " + NostrJavaRelayClientIT.getRelayUri() + " - error", (Throwable)cause);
        Assertions.assertEquals((Object)NostrJavaRelayClientIT.getRelayUri(), (Object)exception.getRelayUrl(), (String)"Relay URL should be extracted");
        Assertions.assertEquals((Object)cause, (Object)exception.getCause(), (String)"Cause should be preserved");
        Assertions.assertNotNull((Object)exception.toRelayUnavailableException(), (String)"Should convert to RelayUnavailableException");
    }

    @Test
    void testRelayPublishException_retryable() {
        IOException cause = new IOException("Network error");
        NostrJavaRelayClient.RelayPublishException exception = new NostrJavaRelayClient.RelayPublishException("Failed to publish event to relay: " + NostrJavaRelayClientIT.getRelayUri() + " - error", (Throwable)cause);
        Assertions.assertEquals((Object)NostrJavaRelayClientIT.getRelayUri(), (Object)exception.getRelayUrl(), (String)"Relay URL should be extracted");
        Assertions.assertTrue((boolean)exception.isRetryable(), (String)"IOException should be retryable");
        Assertions.assertEquals((Object)cause, (Object)exception.getCause(), (String)"Cause should be preserved");
    }

    @Test
    void testRelayPublishException_notRetryable() {
        IllegalArgumentException cause = new IllegalArgumentException("Invalid event");
        NostrJavaRelayClient.RelayPublishException exception = new NostrJavaRelayClient.RelayPublishException("Failed to publish event to relay: " + NostrJavaRelayClientIT.getRelayUri() + " - error", (Throwable)cause);
        Assertions.assertFalse((boolean)exception.isRetryable(), (String)"IllegalArgumentException should not be retryable");
    }

    @Test
    void testRelaySubscribeException_retryable() {
        IOException cause = new IOException("Network error");
        NostrJavaRelayClient.RelaySubscribeException exception = new NostrJavaRelayClient.RelaySubscribeException("Failed to subscribe to relay: " + NostrJavaRelayClientIT.getRelayUri() + " - error", (Throwable)cause);
        Assertions.assertEquals((Object)NostrJavaRelayClientIT.getRelayUri(), (Object)exception.getRelayUrl(), (String)"Relay URL should be extracted");
        Assertions.assertTrue((boolean)exception.isRetryable(), (String)"IOException should be retryable");
        Assertions.assertEquals((Object)cause, (Object)exception.getCause(), (String)"Cause should be preserved");
    }

    private NostrEvent createTestEvent() {
        return NostrEvent.unsigned((String)"test-pubkey", (int)1, (String)"Test event content", (Instant)Instant.now(), List.of());
    }

    private NostrSubscription createTestSubscription() {
        return new NostrSubscription("test-subscription", event -> true);
    }

    private IdentityKey createTestIdentityKey() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("EC");
            keyGen.initialize(256);
            KeyPair keyPair = keyGen.generateKeyPair();
            return new IdentityKey(keyPair.getPrivate(), keyPair.getPublic());
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create test identity key", e);
        }
    }

    private WalletSigningKey createTestWalletSigningKey() {
        int i;
        byte[] privateKey = new byte[32];
        byte[] publicKey = new byte[32];
        byte[] salt = new byte[16];
        for (i = 0; i < privateKey.length; ++i) {
            privateKey[i] = (byte)i;
        }
        for (i = 0; i < publicKey.length; ++i) {
            publicKey[i] = (byte)(i + 100);
        }
        for (i = 0; i < salt.length; ++i) {
            salt[i] = (byte)(i + 200);
        }
        return new WalletSigningKey(privateKey, publicKey, salt, 1000);
    }
}

