/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import java.security.SecureRandom;
import java.util.HexFormat;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.crypto.schnorr.Schnorr;
import nostr.event.impl.GenericEvent;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.adapter.BaseRelayIntegrationTest;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrEventAdapter;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrJavaRelayClient;
import xyz.tcheeric.wallet.core.nostr.filter.NostrFilterBuilder;
import xyz.tcheeric.wallet.core.nostr.filter.NostrServerSideFilter;

class ServerSideFilterSignedIT
extends BaseRelayIntegrationTest {
    ServerSideFilterSignedIT() {
    }

    @Test
    void subscribeWithServerFilter_receivesSignedEvent() throws Exception {
        String relayUrl = ServerSideFilterSignedIT.getRelayUri();
        byte[] secKey = Schnorr.generatePrivateKey();
        byte[] pubKey = Schnorr.genPubKey((byte[])secKey);
        String pubKeyHex = HexFormat.of().formatHex(pubKey);
        String content = "it-signed-" + String.valueOf(UUID.randomUUID());
        GenericEvent ge = new GenericEvent();
        ge.setPubKey(new PublicKey(pubKeyHex));
        ge.setKind(Integer.valueOf(1));
        ge.setContent(content);
        ge.update();
        byte[] msg = HexFormat.of().parseHex(ge.getId());
        byte[] aux = new SecureRandom().generateSeed(32);
        byte[] sig = Schnorr.sign((byte[])msg, (byte[])secKey, (byte[])aux);
        ge.setSignature(Signature.fromString((String)HexFormat.of().formatHex(sig)));
        ge.validate();
        NostrEvent we = NostrEventAdapter.toWalletEvent((GenericEvent)ge);
        try (NostrJavaRelayClient client = new NostrJavaRelayClient(relayUrl);){
            client.connect();
            NostrServerSideFilter serverFilter = NostrFilterBuilder.newBuilder().authors(new String[]{pubKeyHex}).kinds(new int[]{1}).limit(10).build();
            CountDownLatch latch = new CountDownLatch(1);
            StringBuilder received = new StringBuilder();
            try (AutoCloseable sub = client.subscribe(new NostrSubscription("it-filter", (Predicate)serverFilter), evt -> {
                if (content.equals(evt.content()) && pubKeyHex.equals(evt.pubkey())) {
                    received.setLength(0);
                    received.append(evt.content());
                    latch.countDown();
                }
            });){
                client.publish(we);
                boolean ok = latch.await(5L, TimeUnit.SECONDS);
                Assertions.assertTrue((boolean)ok, (String)"Did not receive signed event in time");
                Assertions.assertEquals((Object)content, (Object)received.toString());
            }
        }
    }
}

