/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import java.lang.reflect.Constructor;
import nostr.client.springwebsocket.SpringWebSocketClient;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.springframework.context.support.GenericApplicationContext;
import xyz.tcheeric.wallet.core.nostr.adapter.SpringContextFactory;

class SpringContextFactoryTest {
    private SpringContextFactory.ManagedSpringContext managedContext;

    SpringContextFactoryTest() {
    }

    @AfterEach
    void cleanup() {
        if (this.managedContext != null && !this.managedContext.isClosed()) {
            this.managedContext.close();
        }
    }

    @Test
    void testCreateContext_nullRelayUrl_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SpringContextFactory.createContextForRelay(null), (String)"Should throw IllegalArgumentException for null relay URL");
    }

    @Test
    void testCreateContext_blankRelayUrl_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SpringContextFactory.createContextForRelay((String)"   "), (String)"Should throw IllegalArgumentException for blank relay URL");
    }

    @Test
    void testCreateContext_emptyRelayUrl_throwsException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> SpringContextFactory.createContextForRelay((String)""), (String)"Should throw IllegalArgumentException for empty relay URL");
    }

    @Test
    void testCreateContext_validRelayUrl_createsContext() {
        String relayUrl = "wss://relay.damus.io";
        try {
            this.managedContext = SpringContextFactory.createContextForRelay((String)relayUrl);
            Assertions.assertNotNull((Object)this.managedContext, (String)"Context should be created");
            Assertions.assertFalse((boolean)this.managedContext.isClosed(), (String)"Context should not be closed initially");
            Assertions.assertNotNull((Object)this.managedContext.getContext(), (String)"Spring context should be available");
        }
        catch (Exception e) {
            Assertions.assertTrue((e.getMessage() == null || e.getMessage().contains("WebSocket") || e.getMessage().contains("connection") || e.getMessage().contains("timeout") ? 1 : 0) != 0, (String)("Exception should be WebSocket-related, not Spring context creation: " + e.getMessage()));
        }
    }

    @Test
    void testGetClient_returnsNonNullClient() {
        String relayUrl = "wss://relay.damus.io";
        try {
            this.managedContext = SpringContextFactory.createContextForRelay((String)relayUrl);
            SpringWebSocketClient client = this.managedContext.getClient();
            Assertions.assertNotNull((Object)client, (String)"Client should not be null");
        }
        catch (Exception e) {
            System.err.println("WebSocket connection failed (expected in test environment): " + e.getMessage());
        }
    }

    @Test
    void testGetClient_afterClose_throwsException() {
        String relayUrl = "wss://relay.damus.io";
        try {
            this.managedContext = SpringContextFactory.createContextForRelay((String)relayUrl);
            this.managedContext.close();
            Assertions.assertThrows(IllegalStateException.class, () -> this.managedContext.getClient(), (String)"Should throw IllegalStateException when getting client from closed context");
        }
        catch (Exception e) {
            System.err.println("Context creation failed: " + e.getMessage());
        }
    }

    @Test
    void testClose_closesSpringContext() {
        String relayUrl = "wss://relay.damus.io";
        try {
            this.managedContext = SpringContextFactory.createContextForRelay((String)relayUrl);
            GenericApplicationContext context = this.managedContext.getContext();
            this.managedContext.close();
            Assertions.assertFalse((boolean)context.isActive(), (String)"Spring context should be closed");
            Assertions.assertTrue((boolean)this.managedContext.isClosed(), (String)"Managed context should report as closed");
        }
        catch (Exception e) {
            System.err.println("Context creation failed: " + e.getMessage());
        }
    }

    @Test
    void testClose_isIdempotent() {
        String relayUrl = "wss://relay.damus.io";
        try {
            this.managedContext = SpringContextFactory.createContextForRelay((String)relayUrl);
            this.managedContext.close();
            this.managedContext.close();
            this.managedContext.close();
            Assertions.assertTrue((boolean)this.managedContext.isClosed(), (String)"Context should remain closed");
        }
        catch (Exception e) {
            System.err.println("Context creation failed: " + e.getMessage());
        }
    }

    @Test
    void testIsClosed_returnsCorrectState() {
        String relayUrl = "wss://relay.damus.io";
        try {
            this.managedContext = SpringContextFactory.createContextForRelay((String)relayUrl);
            Assertions.assertFalse((boolean)this.managedContext.isClosed(), (String)"Context should not be closed initially");
            this.managedContext.close();
            Assertions.assertTrue((boolean)this.managedContext.isClosed(), (String)"Context should be closed after close()");
        }
        catch (Exception e) {
            System.err.println("Context creation failed: " + e.getMessage());
        }
    }

    @Test
    void testContextContainsExpectedBeans() {
        String relayUrl = "wss://relay.damus.io";
        try {
            this.managedContext = SpringContextFactory.createContextForRelay((String)relayUrl);
            GenericApplicationContext context = this.managedContext.getContext();
            Assertions.assertTrue((boolean)context.containsBean("webSocketClientIF"), (String)"Context should contain webSocketClientIF bean");
            Assertions.assertTrue((boolean)context.containsBean("springWebSocketClient"), (String)"Context should contain springWebSocketClient bean");
            String relayUrlProperty = context.getEnvironment().getProperty("nostr.relay.uri");
            Assertions.assertEquals((Object)relayUrl, (Object)relayUrlProperty, (String)"nostr.relay.uri property should match input");
        }
        catch (Exception e) {
            System.err.println("Context creation failed: " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testCreateMultipleContexts_forDifferentRelays() {
        String relay1 = "wss://relay.damus.io";
        String relay2 = "wss://relay.nostr.band";
        SpringContextFactory.ManagedSpringContext context1 = null;
        SpringContextFactory.ManagedSpringContext context2 = null;
        try {
            context1 = SpringContextFactory.createContextForRelay((String)relay1);
            context2 = SpringContextFactory.createContextForRelay((String)relay2);
            Assertions.assertNotNull((Object)context1, (String)"First context should be created");
            Assertions.assertNotNull((Object)context2, (String)"Second context should be created");
            Assertions.assertNotSame((Object)context1.getContext(), (Object)context2.getContext(), (String)"Contexts should be different instances");
            Assertions.assertFalse((boolean)context1.isClosed(), (String)"First context should not be closed");
            Assertions.assertFalse((boolean)context2.isClosed(), (String)"Second context should not be closed");
        }
        catch (Exception e) {
            System.err.println("Context creation failed: " + e.getMessage());
        }
        finally {
            if (context1 != null) {
                context1.close();
            }
            if (context2 != null) {
                context2.close();
            }
        }
    }

    @Test
    void testFactoryClass_cannotBeInstantiated() {
        Assertions.assertThrows(Exception.class, () -> {
            Constructor constructor = SpringContextFactory.class.getDeclaredConstructor(new Class[0]);
            constructor.setAccessible(true);
            constructor.newInstance(new Object[0]);
        }, (String)"Should not be able to instantiate utility class");
    }
}

