/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.adapter;

import java.security.SecureRandom;
import java.util.HexFormat;
import java.util.concurrent.CompletableFuture;
import nostr.base.PrivateKey;
import nostr.base.PublicKey;
import nostr.base.Signature;
import nostr.crypto.schnorr.Schnorr;
import nostr.event.impl.GenericEvent;
import xyz.tcheeric.messaging.contracts.IdentityMessage;
import xyz.tcheeric.messaging.contracts.MessageClient;
import xyz.tcheeric.messaging.messages.SignEventRequest;
import xyz.tcheeric.messaging.messages.SignEventResponse;
import xyz.tcheeric.wallet.core.security.IdentityKey;

public class TestMessageClient
implements MessageClient {
    private final PrivateKey nostrPrivateKey;
    private final PublicKey nostrPublicKey;
    private final SecureRandom random;

    public TestMessageClient(IdentityKey identityKey) {
        if (identityKey.getNostrPrivateKey() != null && identityKey.getNostrPublicKey() != null) {
            this.nostrPrivateKey = identityKey.getNostrPrivateKey();
            this.nostrPublicKey = identityKey.getNostrPublicKey();
        } else {
            byte[] privateKeyBytes = identityKey.privateKey().getEncoded();
            byte[] rawPrivateKey = new byte[32];
            System.arraycopy(privateKeyBytes, privateKeyBytes.length - 32, rawPrivateKey, 0, 32);
            this.nostrPrivateKey = new PrivateKey(rawPrivateKey);
            byte[] publicKeyBytes = Schnorr.genPubKey((byte[])rawPrivateKey);
            this.nostrPublicKey = new PublicKey(publicKeyBytes);
        }
        this.random = new SecureRandom();
    }

    public <T extends IdentityMessage> T sendSync(IdentityMessage message, Class<T> responseType) {
        if (message instanceof SignEventRequest) {
            SignEventRequest request = (SignEventRequest)message;
            try {
                GenericEvent event = new GenericEvent();
                event.setKind(Integer.valueOf(request.kind()));
                event.setContent(request.content());
                event.setCreatedAt(Long.valueOf(request.createdAt()));
                event.setPubKey(this.nostrPublicKey);
                event.update();
                byte[] messageBytes = HexFormat.of().parseHex(event.getId());
                byte[] aux = this.random.generateSeed(32);
                byte[] signatureBytes = Schnorr.sign((byte[])messageBytes, (byte[])this.nostrPrivateKey.getRawData(), (byte[])aux);
                event.setSignature(Signature.fromString((String)HexFormat.of().formatHex(signatureBytes)));
                SignEventResponse response = SignEventResponse.success((String)request.requestId(), (String)event.getId(), (String)event.getSignature().toString(), (String)this.nostrPublicKey.toString());
                return (T)response;
            }
            catch (Exception e) {
                SignEventResponse response = SignEventResponse.failure((String)((SignEventRequest)message).requestId(), (String)("Failed to sign event: " + e.getMessage()));
                return (T)response;
            }
        }
        throw new UnsupportedOperationException("TestMessageClient only supports SignEventRequest, got: " + message.getClass().getSimpleName());
    }

    public <T extends IdentityMessage> CompletableFuture<T> sendAsync(IdentityMessage message, Class<T> responseType) {
        return CompletableFuture.supplyAsync(() -> this.sendSync(message, responseType));
    }
}

