/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.dm;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.List;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.dm.DmCrypto;
import xyz.tcheeric.wallet.core.nostr.dm.DmMessage;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendRequest;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendResult;
import xyz.tcheeric.wallet.core.nostr.dm.DmService;
import xyz.tcheeric.wallet.core.nostr.dm.DmServiceNip04;
import xyz.tcheeric.wallet.core.nostr.dm.NostrDmGateway;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;

class DmServiceNip04Test {
    DmServiceNip04Test() {
    }

    @Test
    void sendAndReceive_loopback_withStubCrypto() throws Exception {
        Path tmp = Files.createTempDirectory("dmtest", new FileAttribute[0]);
        IdentityKeyService id = new IdentityKeyService(tmp);
        WalletKeyManager wm = new WalletKeyManager(SecureKeyStore.create((Path)tmp));
        class FakeGateway
        implements NostrDmGateway {
            Consumer<NostrEvent> consumer;
            NostrEvent lastPublished;

            FakeGateway(DmServiceNip04Test this$0) {
            }

            public void publish(NostrEvent event) {
                this.lastPublished = event;
            }

            public AutoCloseable subscribe(NostrSubscription subscription, Consumer<NostrEvent> consumer) {
                this.consumer = consumer;
                return () -> {
                    this.consumer = null;
                };
            }
        }
        FakeGateway gateway = new FakeGateway(this);
        DmCrypto crypto = new DmCrypto(this){

            public String encrypt(String senderPrivHex, String recipientPubHex, String plaintext) {
                String ct = Base64.getEncoder().encodeToString(plaintext.getBytes());
                return ct + "?iv=AA==";
            }

            public String decrypt(String selfPrivHex, String otherPubHex, String payload) {
                int q = payload.indexOf("?iv=");
                String ct = q > 0 ? payload.substring(0, q) : payload;
                return new String(Base64.getDecoder().decode(ct));
            }
        };
        DmServiceNip04 svc = new DmServiceNip04(id, wm, (NostrDmGateway)gateway, crypto);
        DmSendResult result = svc.send(DmSendRequest.now((String)"00".repeat(32), (String)"hello dm"));
        Assertions.assertNotNull((Object)result.eventId());
        svc.list(DmService.DmQuery.recent((int)10));
        Assertions.assertNotNull(gateway.consumer, (String)"subscription should be active");
        Assertions.assertNotNull((Object)gateway.lastPublished, (String)"publish should have been called");
        gateway.consumer.accept(gateway.lastPublished);
        List messages = svc.list(DmService.DmQuery.recent((int)10));
        Assertions.assertFalse((boolean)messages.isEmpty());
        DmMessage msg = (DmMessage)messages.get(0);
        Assertions.assertEquals((Object)"hello dm", (Object)msg.content());
        Assertions.assertEquals((Object)gateway.lastPublished.id(), (Object)msg.eventId());
        Assertions.assertEquals((long)gateway.lastPublished.createdAt().getEpochSecond(), (long)msg.createdAt().getEpochSecond());
    }
}

