/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.dm;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.adapter.BaseRelayIntegrationTest;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrJavaRelayClient;
import xyz.tcheeric.wallet.core.nostr.dm.DmCrypto;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendRequest;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendResult;
import xyz.tcheeric.wallet.core.nostr.dm.DmServiceNip04;
import xyz.tcheeric.wallet.core.nostr.dm.NostrDmGateway;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;

class DmServiceNip04TestcontainersIT
extends BaseRelayIntegrationTest {
    DmServiceNip04TestcontainersIT() {
    }

    @Test
    void dmSend_overRelayContainer_succeeds() throws Exception {
        final String relayUrl = DmServiceNip04TestcontainersIT.getRelayUri();
        Path tmp = Files.createTempDirectory("dm-it-relay", new FileAttribute[0]);
        IdentityKeyService id = new IdentityKeyService(tmp);
        WalletKeyManager wm = new WalletKeyManager(SecureKeyStore.create((Path)tmp));
        DmCrypto crypto = new DmCrypto(this){

            public String encrypt(String senderPrivHex, String recipientPubHex, String plaintext) {
                String ct = Base64.getEncoder().encodeToString(plaintext.getBytes());
                return ct + "?iv=AA==";
            }

            public String decrypt(String selfPrivHex, String otherPubHex, String payload) {
                int q = payload.indexOf("?iv=");
                String ct = q > 0 ? payload.substring(0, q) : payload;
                return new String(Base64.getDecoder().decode(ct));
            }
        };
        class RelayDmGateway
        implements NostrDmGateway,
        AutoCloseable {
            final NostrJavaRelayClient client;

            RelayDmGateway() {
                this.client = new NostrJavaRelayClient(relayUrl);
                this.client.connect();
            }

            public void publish(NostrEvent event) {
                this.client.publish(event);
            }

            public AutoCloseable subscribe(NostrSubscription subscription, Consumer<NostrEvent> consumer) {
                return this.client.subscribe(subscription, consumer);
            }

            @Override
            public void close() {
                this.client.close();
            }
        }
        try (RelayDmGateway gateway = new RelayDmGateway();){
            DmServiceNip04 svc = new DmServiceNip04(id, wm, (NostrDmGateway)gateway, crypto);
            DmSendResult res = svc.send(DmSendRequest.now((String)"00".repeat(32), (String)"hello over relay"));
            Assertions.assertNotNull((Object)res.eventId());
            CountDownLatch latch = new CountDownLatch(1);
            latch.await(200L, TimeUnit.MILLISECONDS);
        }
    }
}

