/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.dm;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.List;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.dm.DmCrypto44;
import xyz.tcheeric.wallet.core.nostr.dm.DmMessage;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendRequest;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendResult;
import xyz.tcheeric.wallet.core.nostr.dm.DmService;
import xyz.tcheeric.wallet.core.nostr.dm.DmServiceNip44;
import xyz.tcheeric.wallet.core.nostr.dm.NostrDmGateway;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;

class DmServiceNip44Test {
    DmServiceNip44Test() {
    }

    @Test
    void sendAndReceive_loopback_withStubCrypto() throws Exception {
        Path tmp = Files.createTempDirectory("dm44test", new FileAttribute[0]);
        IdentityKeyService id = new IdentityKeyService(tmp);
        WalletKeyManager wm = new WalletKeyManager(SecureKeyStore.create((Path)tmp));
        class FakeGateway
        implements NostrDmGateway {
            Consumer<NostrEvent> consumer;
            NostrEvent lastPublished;

            FakeGateway(DmServiceNip44Test this$0) {
            }

            public void publish(NostrEvent event) {
                this.lastPublished = event;
            }

            public AutoCloseable subscribe(NostrSubscription subscription, Consumer<NostrEvent> consumer) {
                this.consumer = consumer;
                return () -> {
                    this.consumer = null;
                };
            }
        }
        FakeGateway gateway = new FakeGateway(this);
        DmCrypto44 crypto = new DmCrypto44(this){

            public String encrypt(String senderPrivHex, String recipientPubHex, String plaintext) {
                return Base64.getEncoder().encodeToString(plaintext.getBytes()) + "?v=44";
            }

            public String decrypt(String selfPrivHex, String otherPubHex, String payload) {
                String ct = payload.replace("?v=44", "");
                return new String(Base64.getDecoder().decode(ct));
            }
        };
        DmServiceNip44 svc = new DmServiceNip44(id, wm, (NostrDmGateway)gateway, crypto);
        DmSendResult res = svc.send(DmSendRequest.now((String)"00".repeat(32), (String)"hello nip44"));
        Assertions.assertNotNull((Object)res.eventId());
        svc.list(DmService.DmQuery.recent((int)10));
        Assertions.assertNotNull(gateway.consumer);
        gateway.consumer.accept(gateway.lastPublished);
        List messages = svc.list(DmService.DmQuery.recent((int)10));
        Assertions.assertFalse((boolean)messages.isEmpty());
        Assertions.assertEquals((Object)"hello nip44", (Object)((DmMessage)messages.get(0)).content());
    }
}

