/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.dm;

import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Base64;
import java.util.function.Consumer;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.NostrEvent;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.adapter.BaseRelayIntegrationTest;
import xyz.tcheeric.wallet.core.nostr.adapter.NostrJavaRelayClient;
import xyz.tcheeric.wallet.core.nostr.dm.DmCrypto44;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendRequest;
import xyz.tcheeric.wallet.core.nostr.dm.DmSendResult;
import xyz.tcheeric.wallet.core.nostr.dm.DmServiceNip44;
import xyz.tcheeric.wallet.core.nostr.dm.NostrDmGateway;
import xyz.tcheeric.wallet.core.security.IdentityKeyService;
import xyz.tcheeric.wallet.core.security.SecureKeyStore;
import xyz.tcheeric.wallet.core.security.WalletKeyManager;

class DmServiceNip44TestcontainersIT
extends BaseRelayIntegrationTest {
    DmServiceNip44TestcontainersIT() {
    }

    @Test
    void nip44_send_over_container() throws Exception {
        final String relayUrl = DmServiceNip44TestcontainersIT.getRelayUri();
        Path tmp = Files.createTempDirectory("dm44-cont", new FileAttribute[0]);
        IdentityKeyService id = new IdentityKeyService(tmp);
        WalletKeyManager wm = new WalletKeyManager(SecureKeyStore.create((Path)tmp));
        DmCrypto44 crypto = new DmCrypto44(this){

            public String encrypt(String sp, String rp, String pt) {
                return Base64.getEncoder().encodeToString(pt.getBytes()) + "?v=44";
            }

            public String decrypt(String sp, String op, String p) {
                String ct = p.replace("?v=44", "");
                return new String(Base64.getDecoder().decode(ct));
            }
        };
        class RelayDmGateway
        implements NostrDmGateway,
        AutoCloseable {
            final NostrJavaRelayClient c;

            RelayDmGateway() {
                this.c = new NostrJavaRelayClient(relayUrl);
                this.c.connect();
            }

            public void publish(NostrEvent e) {
                this.c.publish(e);
            }

            public AutoCloseable subscribe(NostrSubscription s, Consumer<NostrEvent> cons) {
                return this.c.subscribe(s, cons);
            }

            @Override
            public void close() {
                this.c.close();
            }
        }
        try (RelayDmGateway gw = new RelayDmGateway();){
            DmServiceNip44 svc = new DmServiceNip44(id, wm, (NostrDmGateway)gw, crypto);
            DmSendResult res = svc.send(DmSendRequest.now((String)"00".repeat(32), (String)"hello nip44 over relay"));
            Assertions.assertNotNull((Object)res.eventId());
        }
    }
}

