/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.filter;

import java.time.Instant;
import java.util.List;
import java.util.function.Predicate;
import nostr.event.filter.Filters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.adapter.SubscriptionAdapter;
import xyz.tcheeric.wallet.core.nostr.filter.NostrFilterBuilder;
import xyz.tcheeric.wallet.core.nostr.filter.NostrServerSideFilter;

class NostrFilterBuilderAdvancedTest {
    NostrFilterBuilderAdvancedTest() {
    }

    @Test
    void testIdentifiersFilter() {
        NostrServerSideFilter pred = NostrFilterBuilder.newBuilder().identifiers(new String[]{"doc-1", "doc-2"}).build();
        NostrSubscription sub = new NostrSubscription("id-sub", (Predicate)pred);
        List list = SubscriptionAdapter.toNostrJavaFilters((NostrSubscription)sub);
        Assertions.assertNotNull((Object)list);
        Filters f = (Filters)list.getFirst();
        Assertions.assertFalse((boolean)f.getFilterByType("#d").isEmpty(), (String)"#d identifier filter present");
        Assertions.assertEquals((int)2, (int)f.getFilterByType("#d").size());
    }

    @Test
    void testAddressFilterWithRelay() {
        NostrServerSideFilter pred = NostrFilterBuilder.newBuilder().address(30000, "deadbeef", "profile-1", "wss://relay.example").build();
        NostrSubscription sub = new NostrSubscription("addr-sub", (Predicate)pred);
        List list = SubscriptionAdapter.toNostrJavaFilters((NostrSubscription)sub);
        Filters f = (Filters)list.getFirst();
        Assertions.assertFalse((boolean)f.getFilterByType("#a").isEmpty(), (String)"#a address filter present");
    }

    @Test
    void testGeohashUrlVoteFilters() {
        NostrServerSideFilter pred = NostrFilterBuilder.newBuilder().geohashes(new String[]{"u4pruydqqvj"}).urls(new String[]{"https://example.com"}).votes(new int[]{1, -1}).build();
        NostrSubscription sub = new NostrSubscription("misc-tags", (Predicate)pred);
        List list = SubscriptionAdapter.toNostrJavaFilters((NostrSubscription)sub);
        Filters f = (Filters)list.getFirst();
        Assertions.assertFalse((boolean)f.getFilterByType("#g").isEmpty(), (String)"#g geohash filter present");
        Assertions.assertFalse((boolean)f.getFilterByType("#u").isEmpty(), (String)"#u url filter present");
        Assertions.assertEquals((int)2, (int)f.getFilterByType("#v").size(), (String)"two vote filters present");
    }

    @Test
    void testConvenience_textNotesByAuthorsSince() {
        NostrServerSideFilter filter = NostrFilterBuilder.textNotesByAuthorsSince(List.of("aa", "bb"), (Instant)Instant.ofEpochSecond(1700000000L), (int)25);
        NostrSubscription sub = new NostrSubscription("preset", (Predicate)filter);
        List list = SubscriptionAdapter.toNostrJavaFilters((NostrSubscription)sub);
        Filters f = (Filters)list.getFirst();
        Assertions.assertFalse((boolean)f.getFilterByType("kinds").isEmpty(), (String)"kinds present");
        Assertions.assertEquals((int)2, (int)f.getFilterByType("authors").size(), (String)"authors present");
        Assertions.assertEquals((int)25, (Integer)f.getLimit());
    }
}

