/*
 * Decompiled with CFR 0.152.
 */
package xyz.tcheeric.wallet.core.nostr.filter;

import java.time.Instant;
import java.util.List;
import java.util.function.Predicate;
import nostr.event.filter.Filters;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import xyz.tcheeric.wallet.core.nostr.NostrSubscription;
import xyz.tcheeric.wallet.core.nostr.adapter.SubscriptionAdapter;
import xyz.tcheeric.wallet.core.nostr.filter.NostrFilterBuilder;
import xyz.tcheeric.wallet.core.nostr.filter.NostrServerSideFilter;

class NostrFilterBuilderTest {
    NostrFilterBuilderTest() {
    }

    @Test
    void testBuild_simpleAuthorsKindsSinceLimit() {
        NostrServerSideFilter predicate = NostrFilterBuilder.newBuilder().authors(new String[]{"001122"}).kinds(new int[]{1, 4}).since(Instant.ofEpochSecond(1700000000L)).limit(42).build();
        NostrSubscription sub = new NostrSubscription("adv-sub", (Predicate)predicate);
        List filtersList = SubscriptionAdapter.toNostrJavaFilters((NostrSubscription)sub);
        Assertions.assertNotNull((Object)filtersList, (String)"Server-side filters should be present");
        Assertions.assertEquals((int)1, (int)filtersList.size(), (String)"Single filter group expected");
        Filters f = (Filters)filtersList.getFirst();
        Assertions.assertEquals((int)42, (Integer)f.getLimit(), (String)"Custom limit should be set");
        Assertions.assertFalse((boolean)f.getFilterByType("authors").isEmpty(), (String)"authors filter present");
        Assertions.assertFalse((boolean)f.getFilterByType("kinds").isEmpty(), (String)"kinds filter present");
        int total = f.getFiltersMap().values().stream().mapToInt(List::size).sum();
        Assertions.assertTrue((total >= 3 ? 1 : 0) != 0, (String)"At least authors+kinds+since present");
    }

    @Test
    void testBuild_orGroups() {
        NostrServerSideFilter predicate = NostrFilterBuilder.newBuilder().kinds(new int[]{1}).authors(new String[]{"aa"}).orGroup().kinds(new int[]{4}).authors(new String[]{"bb"}).build();
        NostrSubscription sub = new NostrSubscription("or-sub", (Predicate)predicate);
        List list = SubscriptionAdapter.toNostrJavaFilters((NostrSubscription)sub);
        Assertions.assertNotNull((Object)list);
        Assertions.assertEquals((int)2, (int)list.size(), (String)"Two OR groups expected");
    }

    @Test
    void testBuild_referencedTags() {
        NostrServerSideFilter predicate = NostrFilterBuilder.newBuilder().referencedEvents(new String[]{"event123"}).referencedPubKeys(new String[]{"deadbeef"}).build();
        NostrSubscription sub = new NostrSubscription("tags-sub", (Predicate)predicate);
        List list = SubscriptionAdapter.toNostrJavaFilters((NostrSubscription)sub);
        Assertions.assertNotNull((Object)list);
        Filters f = (Filters)list.getFirst();
        Assertions.assertFalse((boolean)f.getFilterByType("#e").isEmpty(), (String)"#e filter present");
        Assertions.assertFalse((boolean)f.getFilterByType("#p").isEmpty(), (String)"#p filter present");
    }
}

